/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.ual.util;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Locale;

public class CanonicalizeHelper {
    public String canonicalize(String uri) throws URISyntaxException {
        URI normalized = new URI(uri.toLowerCase(Locale.US)).normalize();
        boolean isHttp = "http".equalsIgnoreCase(normalized.getScheme());
        boolean isHttps = "https".equalsIgnoreCase(normalized.getScheme());
        if (isHttp || isHttps) {
            int port = normalized.getPort() == -1 ? (isHttp ? 80 : 443) : normalized.getPort();
            String path = normalized.getPath();
            String canonicalizedPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
            return String.format("%s://%s:%d%s", normalized.getScheme(), normalized.getHost(), port, canonicalizedPath);
        }
        throw new URISyntaxException(uri, "The protocol can only be \"http\" or \"https\"");
    }
}

