/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.ual;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual.ApplicationLinkIdMapper;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstanceBuilder;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalUpgradeHelper;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalUpgrader;
import com.atlassian.jirafisheyeplugin.upgrade.ual.util.CanonicalizeHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UalUpgraderImpl
implements UalUpgrader {
    private static final Logger log = LoggerFactory.getLogger(UalUpgraderImpl.class);
    private final FishEyeProperties fisheyeProperties;
    private final ApplicationLinkService applicationLinkService;
    private final FishEyeInstanceStore fishEyeInstanceStore;
    private final UalUpgradeHelper ualUpgradeHelper;
    private final ApplicationLinkIdMapper applicationLinkIdMapper;
    private final FishEyeInstanceManager fishEyeInstanceManager;

    public UalUpgraderImpl(FishEyeProperties fisheyeProperties, ApplicationLinkService applicationLinkService, FishEyeInstanceStore fishEyeInstanceStore, UalUpgradeHelper ualUpgradeHelper, ApplicationLinkIdMapper applicationLinkIdMapper, FishEyeInstanceManager fishEyeInstanceManager) {
        this.fisheyeProperties = fisheyeProperties;
        this.applicationLinkService = applicationLinkService;
        this.fishEyeInstanceStore = fishEyeInstanceStore;
        this.ualUpgradeHelper = ualUpgradeHelper;
        this.applicationLinkIdMapper = applicationLinkIdMapper;
        this.fishEyeInstanceManager = fishEyeInstanceManager;
    }

    @Override
    public boolean isUpgradeNeeded() {
        return !this.isAlreadyUpgraded() || !this.applinksSynced() || !this.hasNoStaleFisheyeInstances();
    }

    private boolean hasNoStaleFisheyeInstances() {
        return Collections2.filter(this.fishEyeInstanceStore.getAllFishEyeInstances(), (Predicate)new Predicate<FishEyeInstance>(){

            public boolean apply(FishEyeInstance input) {
                ApplicationId applicationId = UalUpgraderImpl.this.applicationLinkIdMapper.fromInstanceId(input.getId());
                try {
                    boolean stale;
                    boolean bl = stale = applicationId == null || UalUpgraderImpl.this.applicationLinkService.getApplicationLink(applicationId) == null;
                    if (stale) {
                        log.info("Found stale Fisheye Instance [" + input + "], upgrading...");
                    }
                    return stale;
                }
                catch (TypeNotInstalledException e) {
                    throw new RuntimeException("The required ApplicationLink type is not installed", e);
                }
            }
        }).isEmpty();
    }

    private boolean applinksSynced() {
        for (ApplicationLink existing : this.applicationLinkService.getApplicationLinks(FishEyeCrucibleApplicationType.class)) {
            if (this.applicationLinkIdMapper.fromApplicationId(existing.getId()) != null) continue;
            log.info("Found new application link [" + existing.getId() + "] that does not have corresponding Fisheye Instance, upgrading...");
            return false;
        }
        return true;
    }

    private boolean isAlreadyUpgraded() {
        List<FishEyeInstance> all = this.fishEyeInstanceStore.getAllFishEyeInstances();
        return Collections2.filter(all, (Predicate)new Predicate<FishEyeInstance>(){

            public boolean apply(FishEyeInstance from) {
                return !UalUpgraderImpl.this.isUpgraded(from);
            }
        }).isEmpty();
    }

    private boolean isUpgraded(FishEyeInstance fishEyeInstance) {
        return this.falseIfNull(this.fisheyeProperties.getBoolean("fisheye.ual.upgrade.completed", fishEyeInstance.getId()));
    }

    private boolean falseIfNull(Boolean bool) {
        return bool == null ? false : bool;
    }

    @Override
    public void performUpgrade() {
        List<FishEyeInstance> allFishEyeInstances = this.fishEyeInstanceStore.getAllFishEyeInstances();
        ArrayList upgradedInstances = Lists.newArrayList((Iterable)Collections2.filter(allFishEyeInstances, (Predicate)new Predicate<FishEyeInstance>(){

            public boolean apply(FishEyeInstance input) {
                return UalUpgraderImpl.this.isUpgraded(input);
            }
        }));
        ArrayList unUpgradedInstances = Lists.newArrayList((Iterable)Collections2.filter(allFishEyeInstances, (Predicate)new Predicate<FishEyeInstance>(){

            public boolean apply(FishEyeInstance input) {
                return !UalUpgraderImpl.this.isUpgraded(input);
            }
        }));
        Iterable existingApplinks = this.applicationLinkService.getApplicationLinks(FishEyeCrucibleApplicationType.class);
        Map<String, ApplicationLink> applinksByUrl = this.getApplicationLinksByUrl(existingApplinks);
        Map<ApplicationId, ApplicationLink> applinksById = this.getApplicationLinksById(existingApplinks);
        this.printDebugLogging(unUpgradedInstances, upgradedInstances, applinksByUrl);
        this.removeStaleInstances(upgradedInstances);
        unUpgradedInstances.addAll(this.fixCorruptedInstances(upgradedInstances, applinksByUrl, applinksById));
        this.addOrMergeToApplinks(unUpgradedInstances, applinksByUrl, applinksById);
        this.addNewFisheyeInstances(Lists.newArrayList((Iterator)Iterators.concat(upgradedInstances.iterator(), unUpgradedInstances.iterator())), applinksByUrl);
    }

    private void addNewFisheyeInstances(List<FishEyeInstance> allFishEyeInstances, Map<String, ApplicationLink> allApplinksByUrl) {
        HashMap allFisheyeInstancesById = Maps.newHashMap();
        for (FishEyeInstance fishEyeInstance : allFishEyeInstances) {
            allFisheyeInstancesById.put(fishEyeInstance.getId(), fishEyeInstance);
        }
        if (!allApplinksByUrl.isEmpty()) {
            for (Map.Entry entry : allApplinksByUrl.entrySet()) {
                ApplicationLink applicationLink = (ApplicationLink)entry.getValue();
                if (allFisheyeInstancesById.containsKey(this.applicationLinkIdMapper.fromApplicationId(applicationLink.getId()))) continue;
                log.info("Creating new fisheye instance for application link [{}]", (Object)applicationLink);
                FishEyeInstance newInstance = this.fishEyeInstanceManager.create(applicationLink);
                this.ualUpgradeHelper.mergeApplinksInstance(newInstance, applicationLink);
            }
        }
    }

    public void addOrMergeToApplinks(List<FishEyeInstance> unUpgradedInstances, Map<String, ApplicationLink> newInstancesByUrl, Map<ApplicationId, ApplicationLink> newInstancesById) {
        for (FishEyeInstance oldInstance : unUpgradedInstances) {
            log.info("starting upgrade of fisheye instance [{}]", (Object)oldInstance);
            try {
                ApplicationLink applicationLink = this.tryMatch(oldInstance, newInstancesById, newInstancesByUrl);
                if (applicationLink != null) {
                    log.info("merging application link to fisheye with url [{}] in instance [{}]", (Object)oldInstance.getUrl(), (Object)oldInstance);
                    this.ualUpgradeHelper.mergeApplinksInstance(oldInstance, applicationLink);
                } else {
                    log.info("creating application link to fisheye with url [{}] in instance [{}]", (Object)oldInstance.getUrl(), (Object)oldInstance);
                    applicationLink = this.ualUpgradeHelper.addApplicationLink(oldInstance);
                }
                this.removeInstanceThatWasMatchedById(newInstancesById, newInstancesByUrl, oldInstance, applicationLink);
                this.applicationLinkIdMapper.associate(oldInstance.getId(), applicationLink.getId());
                log.info(String.format("finished upgrade of fisheye instance [%s]", oldInstance));
                this.markInstanceUpgraded(oldInstance);
            }
            catch (URISyntaxException e) {
                log.error(String.format("Ignored instance [%s] for upgrade permanently, because the url [%s] is malformed", oldInstance, oldInstance.getUrl()), (Throwable)e);
                this.deleteInstance(oldInstance, "bad url syntax");
            }
        }
    }

    private void removeInstanceThatWasMatchedById(Map<ApplicationId, ApplicationLink> newInstancesById, Map<String, ApplicationLink> newInstancesByUrl, FishEyeInstance oldInstance, ApplicationLink instanceLink) throws URISyntaxException {
        if (newInstancesById.containsKey(instanceLink.getId())) {
            ApplicationLink removed = newInstancesById.remove(instanceLink.getId());
            newInstancesByUrl.remove(this.canonicalize(removed.getRpcUrl().toString()));
            log.info(String.format("Reusing existing application link '%s' with alternate URL '%s' (was '%s')", removed.getName(), removed.getRpcUrl(), oldInstance.getApiUrl()));
        }
    }

    private List<FishEyeInstance> fixCorruptedInstances(List<FishEyeInstance> upgradedInstances, Map<String, ApplicationLink> applinksByUrl, Map<ApplicationId, ApplicationLink> applinksById) {
        Function<FishEyeInstance, ApplicationId> toApplicationId = new Function<FishEyeInstance, ApplicationId>(){

            public ApplicationId apply(FishEyeInstance from) {
                return from.getApplicationId();
            }
        };
        ImmutableListMultimap instancesByApplicationId = Multimaps.index(upgradedInstances, (Function)toApplicationId);
        ArrayList requiresFixing = Lists.newArrayList();
        for (ApplicationId applicationId : instancesByApplicationId.keySet()) {
            List mappedFisheyeInstances = instancesByApplicationId.get((Object)applicationId);
            if (mappedFisheyeInstances.size() <= 1) continue;
            for (FishEyeInstance corruptedFisheyeInstance : mappedFisheyeInstances) {
                log.info(String.format("Found corrupted fisheye instance configuration [%s] : attempting to fix...", corruptedFisheyeInstance));
                this.markInstanceUnupgraded(corruptedFisheyeInstance);
                this.applicationLinkIdMapper.dissociate(corruptedFisheyeInstance.getId(), applicationId);
                try {
                    ApplicationLink applicationLink = this.applicationLinkService.getApplicationLink(applicationId);
                    if (applicationLink != null) {
                        applinksByUrl.remove(this.canonicalize(applicationLink.getRpcUrl().toString()));
                    }
                    applinksById.remove(applicationId);
                    this.ualUpgradeHelper.deleteApplicationLink(applicationId);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException("unexpected error : url incorrect", e);
                }
                catch (TypeNotInstalledException e) {
                    throw new RuntimeException("unexpected error : type not installed", e);
                }
                requiresFixing.add(FishEyeInstanceBuilder.copyOf(corruptedFisheyeInstance).withApplicationId(null).build());
            }
        }
        return requiresFixing;
    }

    private void removeStaleInstances(List<FishEyeInstance> upgradedInstances) {
        for (FishEyeInstance upgradedInstance : upgradedInstances) {
            try {
                ApplicationId applinkId = this.applicationLinkIdMapper.fromInstanceId(upgradedInstance.getId());
                if (applinkId == null) {
                    log.info(String.format("Found old fisheye instance [%s] with no matching application id. Deleting...", upgradedInstance));
                    this.deleteInstance(upgradedInstance, "Stale fisheye instance");
                    continue;
                }
                ApplicationLink found = this.applicationLinkService.getApplicationLink(applinkId);
                if (found != null) continue;
                log.info(String.format("Found old fisheye instance [%s] with no matching application link. Deleting...", upgradedInstance));
                this.deleteInstance(upgradedInstance, "Stale fisheye instance");
            }
            catch (TypeNotInstalledException e) {
                log.info(String.format("Error trying to match instance [%s] with : %s", upgradedInstance, e.getMessage()));
                this.deleteInstance(upgradedInstance, "bad url syntax");
            }
        }
    }

    private ApplicationLink tryMatch(FishEyeInstance fishEyeInstance, Map<ApplicationId, ApplicationLink> newInstancesById, Map<String, ApplicationLink> newInstancesByUrl) throws URISyntaxException {
        ApplicationLink found = this.tryMatchByApplicationId(fishEyeInstance, newInstancesById);
        if (found == null) {
            found = this.tryMatchByUrl(fishEyeInstance, newInstancesByUrl);
        }
        return found;
    }

    private ApplicationLink tryMatchByUrl(FishEyeInstance fishEyeInstance, Map<String, ApplicationLink> newInstancesByUrl) throws URISyntaxException {
        ApplicationLink found = this.tryMatchByUrl(fishEyeInstance.getEffectiveApiUrl(), newInstancesByUrl);
        return found;
    }

    private ApplicationLink tryMatchByApplicationId(FishEyeInstance fishEyeInstance, Map<ApplicationId, ApplicationLink> newInstancesById) {
        ApplicationId fisheyeInstance = this.guessApplicationId(fishEyeInstance);
        return newInstancesById.get(fisheyeInstance);
    }

    private ApplicationId guessApplicationId(FishEyeInstance fishEyeInstance) {
        return this.ualUpgradeHelper.getApplicationIdFromUrl(fishEyeInstance.getEffectiveApiUrl());
    }

    private void deleteInstance(FishEyeInstance oldInstance, String reason) {
        log.warn("Removing fisheye instance. Reason: {}", (Object)reason);
        this.fishEyeInstanceStore.deleteFishEyeInstance(oldInstance);
    }

    private void printDebugLogging(List<FishEyeInstance> unUpgradedInstances, List<FishEyeInstance> upgradedInstances, Map<String, ApplicationLink> uris) {
        log.info("attempting sync check of upgraded fisheye instances:");
        for (FishEyeInstance fishEyeInstance : upgradedInstances) {
            log.info(String.format("\t\t[%s]", fishEyeInstance));
        }
        log.info("attempting upgrade of the following fisheye instances to application links:");
        for (FishEyeInstance fishEyeInstance : unUpgradedInstances) {
            log.info(String.format("\t\t[%s]", fishEyeInstance));
        }
        log.info("attempting upgrade against the following application links:");
        for (Map.Entry entry : uris.entrySet()) {
            log.info(String.format("\t\t[%s]->[%s]", entry.getKey(), entry.getValue()));
        }
    }

    private Map<ApplicationId, ApplicationLink> getApplicationLinksById(Iterable<ApplicationLink> applicationLinks) {
        HashMap applinksMap = Maps.newHashMap();
        for (ApplicationLink applicationLink : applicationLinks) {
            applinksMap.put(applicationLink.getId(), applicationLink);
        }
        return applinksMap;
    }

    private Map<String, ApplicationLink> getApplicationLinksByUrl(Iterable<ApplicationLink> applicationLinks) {
        HashMap applinksMap = Maps.newHashMap();
        for (ApplicationLink applicationLink : applicationLinks) {
            try {
                applinksMap.put(this.canonicalize(applicationLink.getRpcUrl().toString()), applicationLink);
            }
            catch (URISyntaxException e) {
                log.warn(String.format("The Application Link [%s] has an invalid RPC url [%s] : %s. Ignored from upgrade permanently", applicationLink, applicationLink.getRpcUrl(), e.getMessage()));
            }
        }
        return applinksMap;
    }

    private ApplicationLink tryMatchByUrl(String oldInstanceUrl, Map<String, ApplicationLink> applinksInstances) throws URISyntaxException {
        return applinksInstances.remove(this.canonicalize(oldInstanceUrl));
    }

    private String canonicalize(String uri) throws URISyntaxException {
        return new CanonicalizeHelper().canonicalize(uri);
    }

    private void markInstanceUpgraded(FishEyeInstance instance) {
        this.fishEyeInstanceStore.markInstanceUpgraded(instance);
    }

    private void markInstanceUnupgraded(FishEyeInstance instance) {
        this.fisheyeProperties.setBoolean("fisheye.ual.upgrade.completed", false, instance.getId());
    }
}

