/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.ual;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationType;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityType;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleProjectEntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeRepositoryEntityType;
import com.atlassian.applinks.api.application.jira.JiraProjectEntityType;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.BasicAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.OAuthAuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TrustedAppsAuthenticationProvider;
import com.atlassian.applinks.spi.Manifest;
import com.atlassian.applinks.spi.application.ApplicationIdUtil;
import com.atlassian.applinks.spi.auth.AuthenticationConfigurationManager;
import com.atlassian.applinks.spi.link.ApplicationLinkDetails;
import com.atlassian.applinks.spi.link.EntityLinkBuilderFactory;
import com.atlassian.applinks.spi.link.MutableApplicationLink;
import com.atlassian.applinks.spi.link.MutatingApplicationLinkService;
import com.atlassian.applinks.spi.link.MutatingEntityLinkService;
import com.atlassian.applinks.spi.manifest.ManifestNotFoundException;
import com.atlassian.applinks.spi.manifest.ManifestRetriever;
import com.atlassian.applinks.spi.util.TypeAccessor;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalUpgradeHelper;
import com.atlassian.jirafisheyeplugin.upgrade.ual.util.CanonicalizeHelper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UalUpgradeHelperImpl
implements UalUpgradeHelper {
    private static Logger log = LoggerFactory.getLogger(UalUpgradeHelperImpl.class);
    private static final List<Class<? extends AuthenticationProvider>> AUTHENTICATION_PROVIDERS = Lists.newArrayList((Object[])new Class[]{BasicAuthenticationProvider.class, TrustedAppsAuthenticationProvider.class, OAuthAuthenticationProvider.class});
    private final AuthenticationProviderConfiguration[] configurations;
    private final CrucibleProjectStore crucibleProjectStore;
    private final FishEyeRepositoryStore fishEyeRepositoryStore;
    private final MutatingApplicationLinkService applinkservice;
    private final MutatingEntityLinkService entityLinkService;
    private final EntityLinkBuilderFactory entityLinkBuilderFactory;
    private final TypeAccessor typeAccessor;
    private final AuthenticationConfigurationManager authConfigurationManager;
    private final ManifestRetriever manifestRetriever;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authenticationContext;

    public UalUpgradeHelperImpl(CrucibleProjectStore crucibleProjectStore, FishEyeRepositoryStore fishEyeRepositoryStore, MutatingApplicationLinkService mutatingApplicationLinkService, MutatingEntityLinkService entityLinkService, EntityLinkBuilderFactory entityLinkBuilderFactory, TypeAccessor typeAccessor, AuthenticationConfigurationManager authConfigurationManager, ManifestRetriever manifestRetriever, ProjectManager projectManager, JiraAuthenticationContext authenticationContext) {
        this.crucibleProjectStore = crucibleProjectStore;
        this.fishEyeRepositoryStore = fishEyeRepositoryStore;
        this.applinkservice = mutatingApplicationLinkService;
        this.entityLinkService = entityLinkService;
        this.entityLinkBuilderFactory = entityLinkBuilderFactory;
        this.typeAccessor = typeAccessor;
        this.authConfigurationManager = authConfigurationManager;
        this.manifestRetriever = manifestRetriever;
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
        this.configurations = new AuthenticationProviderConfiguration[]{new BasicAuthAuthenticationProviderConfiguration(), new TrustedAppsAuthenticationProviderConfiguration()};
    }

    @Override
    public ApplicationLink addApplicationLink(FishEyeInstance fisheyeInstance) throws URISyntaxException {
        ApplicationLink applicationLink = this.tryCreateApplinks(fisheyeInstance);
        this.configureAuthProvider(fisheyeInstance, applicationLink);
        this.createEntityLinks(fisheyeInstance, applicationLink);
        return applicationLink;
    }

    @Override
    public void mergeApplinksInstance(FishEyeInstance oldInstance, ApplicationLink applinksInstance) {
        this.configureAuthProvider(oldInstance, applinksInstance);
        this.mergeEntityLinks(oldInstance, applinksInstance);
    }

    @Override
    public ApplicationId getApplicationIdFromUrl(String url) {
        try {
            log.debug(String.format("Trying to get the application id by retrieving the manifest for [%s].", url));
            Manifest manifest = this.manifestRetriever.getManifest(URI.create(url), this.typeAccessor.getApplicationType(FishEyeCrucibleApplicationType.class));
            return manifest.getId();
        }
        catch (ManifestNotFoundException e) {
            log.error(String.format("FishEyeCrucibleApplicationType not installed: cannot retrieve manifest for url [%s]", url), (Throwable)e);
            return null;
        }
    }

    @Override
    public void deleteApplicationLink(ApplicationId applicationId) {
        try {
            MutableApplicationLink applicationLink = this.applinkservice.getApplicationLink(applicationId);
            if (applicationLink != null) {
                this.applinkservice.deleteApplicationLink((ApplicationLink)applicationLink);
            }
        }
        catch (TypeNotInstalledException typeNotInstalledException) {
            // empty catch block
        }
    }

    private I18nHelper getI18nHelper() {
        return this.authenticationContext.getI18nHelper();
    }

    private ApplicationLink tryCreateApplinks(FishEyeInstance fisheyeInstance) throws URISyntaxException {
        MutableApplicationLink applicationLink;
        ApplicationId id;
        FishEyeCrucibleApplicationType applicationType = (FishEyeCrucibleApplicationType)this.typeAccessor.getApplicationType(FishEyeCrucibleApplicationType.class);
        URI displayUri = new URI(this.removeTrailingSlash(fisheyeInstance.getUrl()));
        String effectiveApiUrl = this.removeTrailingSlash(fisheyeInstance.getEffectiveApiUrl());
        URI apiUri = new URI(effectiveApiUrl);
        try {
            Manifest manifest = this.manifestRetriever.getManifest(apiUri, (ApplicationType)applicationType);
            id = manifest.getId();
        }
        catch (ManifestNotFoundException e) {
            log.debug(String.format("Error retrieving ual manifest from [%s]", apiUri), (Throwable)e);
            id = ApplicationIdUtil.generate((URI)apiUri);
        }
        ApplicationLinkDetails linkDetails = ApplicationLinkDetails.builder().displayUrl(displayUri).rpcUrl(apiUri).name(this.getI18nHelper().getText("fisheye.ual.fisheye.instance.applink.name", fisheyeInstance.getName(), fisheyeInstance.getUrl())).isPrimary(false).build();
        try {
            applicationLink = this.applinkservice.addApplicationLink(id, (ApplicationType)applicationType, linkDetails);
            log.debug(String.format("created application link [%s]. Continue with configuration of the link", applicationLink));
        }
        catch (IllegalArgumentException e) {
            try {
                applicationLink = this.applinkservice.getApplicationLink(id);
                if (applicationLink == null) {
                    log.debug(String.format("Error creating application link id [%s]:", id), (Throwable)e);
                } else if (!this.isSameServerFuzzy(applicationLink.getRpcUrl(), effectiveApiUrl)) {
                    log.error(String.format("The fisheye instance [%s] is not the same as its intended application link [%s]. Attempting to fix...", fisheyeInstance, applicationLink));
                    this.applinkservice.deleteApplicationLink((ApplicationLink)applicationLink);
                    applicationLink = this.applinkservice.addApplicationLink(id, (ApplicationType)applicationType, linkDetails);
                }
            }
            catch (TypeNotInstalledException err) {
                throw new RuntimeException(String.format("Error getting application link [%s] - type not installed exception:", id), err);
            }
        }
        return applicationLink;
    }

    private String removeTrailingSlash(String effectiveApiUrl) {
        return effectiveApiUrl.endsWith("/") ? effectiveApiUrl.substring(0, effectiveApiUrl.length() - 1) : effectiveApiUrl;
    }

    private boolean isSameServerFuzzy(URI rpcUrl, String effectiveApiUrl) {
        try {
            CanonicalizeHelper canonicalizeHelper = new CanonicalizeHelper();
            String applinksUrl = canonicalizeHelper.canonicalize(rpcUrl.toString());
            String fisheyeInstanceUrl = canonicalizeHelper.canonicalize(effectiveApiUrl);
            return applinksUrl.equalsIgnoreCase(fisheyeInstanceUrl);
        }
        catch (URISyntaxException e) {
            log.error(e.getMessage(), (Throwable)e);
            return false;
        }
    }

    private void createEntityLinks(FishEyeInstance fisheyeInstance, ApplicationLink applicationLink) {
        this.createRepositoryEntitylinks(fisheyeInstance, applicationLink);
        this.createCruProjectEntityLinks(fisheyeInstance, applicationLink);
    }

    private void createCruProjectEntityLinks(FishEyeInstance fisheyeInstance, ApplicationLink applicationLink) {
        for (Project project : this.projectManager.getProjectObjects()) {
            String crucibleProjectKey = this.crucibleProjectStore.getDefaultCrucibleProjectKey(project.getKey(), fisheyeInstance.getId());
            if (crucibleProjectKey == null) continue;
            String operationLog = String.format("creating entity link for jira project [%s] to crucible project [%s] in fisheye instance [%s]", project.getKey(), crucibleProjectKey, fisheyeInstance);
            log.debug(operationLog);
            try {
                this.addCrucibleProjectEntity(applicationLink, project.getKey(), crucibleProjectKey);
            }
            catch (RuntimeException e) {
                log.error("Exception encountered " + operationLog, (Throwable)e);
            }
        }
    }

    private void addCrucibleProjectEntity(ApplicationLink applicationLink, String jiraProject, String crucibleProjectKey) {
        this.addEntity(applicationLink, jiraProject, crucibleProjectKey, this.getI18nHelper().getText("fisheye.ual.project.applink.name", crucibleProjectKey), this.typeAccessor.getEntityType(FishEyeCrucibleProjectEntityType.class));
    }

    private void createRepositoryEntitylinks(FishEyeInstance fisheyeInstance, ApplicationLink applicationLink) {
        Collection<FishEyeRepository> repositories = this.fishEyeRepositoryStore.getRepositoriesForInstance(fisheyeInstance.getId());
        for (FishEyeRepository repository : repositories) {
            Iterable jiraProjectKeys = Iterables.filter(repository.getMappedProjectKeys(), (Predicate)new Predicate<String>(){

                public boolean apply(String projectKey) {
                    return UalUpgradeHelperImpl.this.projectManager.getProjectObjByKey(projectKey) != null;
                }
            });
            for (String jiraProjectKey : jiraProjectKeys) {
                String operationLog = String.format("creating entity link from jira project [%s] to repository [%s] in fisheye instance [%s]", jiraProjectKey, repository.getName(), fisheyeInstance);
                log.debug(operationLog);
                try {
                    this.addRepositoryEntity(applicationLink, jiraProjectKey, repository);
                }
                catch (RuntimeException e) {
                    log.error("Exception encountered " + operationLog, (Throwable)e);
                }
            }
        }
    }

    private void addRepositoryEntity(ApplicationLink applicationLink, String jiraProjectKey, FishEyeRepository fishEyeRepository) {
        this.addEntity(applicationLink, jiraProjectKey, fishEyeRepository.getName(), this.getI18nHelper().getText("fisheye.ual.repository.applink.name", fishEyeRepository.getName()), this.typeAccessor.getEntityType(FishEyeRepositoryEntityType.class));
    }

    private void addEntity(ApplicationLink applicationLink, String jiraProjectKey, String entityKey, String entityName, EntityType entityType) {
        this.entityLinkService.addEntityLink(jiraProjectKey, JiraProjectEntityType.class, this.entityLinkBuilderFactory.builder().type(entityType).key(entityKey).name(entityName).applicationLink(applicationLink).primary(false).build());
    }

    private void configureAuthProvider(FishEyeInstance fisheyeInstance, ApplicationLink applicationLink) {
        for (AuthenticationProviderConfiguration configuration : this.configurations) {
            if (!configuration.isApplicable(fisheyeInstance, applicationLink)) continue;
            log.debug(String.format("Configuring fisheye instance [%s] with authentication configuration [%s]", fisheyeInstance, configuration.getClass().getSimpleName()));
            configuration.configure(fisheyeInstance, applicationLink);
            return;
        }
        log.error(String.format("No authentication configuration found for fisheye instance [%s] when configuring application link [%s]. Please configure an authentication type in the Application Links Configuration Screen.", fisheyeInstance, applicationLink));
    }

    private void mergeEntityLinks(FishEyeInstance oldInstance, ApplicationLink applinksInstance) {
        this.mergeRepositoryEntitylinks(oldInstance, applinksInstance);
        this.mergeCruProjectEntityLinks(oldInstance, applinksInstance);
    }

    private void mergeCruProjectEntityLinks(FishEyeInstance oldInstance, ApplicationLink applinksInstance) {
        HashSet existingCruProjectKeys = Sets.newHashSet(this.crucibleProjectStore.getCrucibleProjectKeys(oldInstance.getId()));
        HashMap entityLinkCruMappings = Maps.newHashMap();
        for (Project project : this.projectManager.getProjectObjects()) {
            Iterable entityLinks = this.entityLinkService.getEntityLinks((Object)project, FishEyeCrucibleProjectEntityType.class);
            for (EntityLink entityLink : entityLinks) {
                if (!applinksInstance.getId().equals((Object)entityLink.getApplicationLink().getId())) continue;
                if (!entityLinkCruMappings.containsKey(entityLink.getKey())) {
                    entityLinkCruMappings.put(entityLink.getKey(), Lists.newArrayList());
                }
                ((List)entityLinkCruMappings.get(entityLink.getKey())).add(project.getKey());
                existingCruProjectKeys.remove(entityLink.getKey());
            }
        }
        for (Map.Entry entry : entityLinkCruMappings.entrySet()) {
            log.info(String.format("Adding crucible mappings [%s] to fisheye instance [%s] from jira project [%s]", entry.getValue(), oldInstance, entry.getKey()));
            this.crucibleProjectStore.setDefaultCrucibleProject((Collection)entry.getValue(), (String)entry.getKey(), oldInstance.getId());
        }
        for (String string : existingCruProjectKeys) {
            for (String jiraProject : this.crucibleProjectStore.getMappedCrucibleProjectKeys(string, oldInstance.getId())) {
                log.info("Adding new crucible project entity link for jira project [{}] with crucible project [{}]", (Object)jiraProject, (Object)string);
                this.addCrucibleProjectEntity(applinksInstance, jiraProject, string);
            }
        }
    }

    private void mergeRepositoryEntitylinks(FishEyeInstance oldInstance, ApplicationLink applinksInstance) {
        final HashMap existingReposMap = Maps.newHashMap();
        Collection<FishEyeRepository> repositories = this.fishEyeRepositoryStore.getRepositoriesForInstance(oldInstance.getId());
        HashSet existingRepos = Sets.newHashSet((Iterable)Collections2.transform(repositories, (Function)new Function<FishEyeRepository, String>(){

            public String apply(FishEyeRepository from) {
                existingReposMap.put(from.getName(), from);
                return from.getName();
            }
        }));
        for (Project project : this.projectManager.getProjectObjects()) {
            Iterable entityLinksForProject = this.entityLinkService.getEntityLinks((Object)project, FishEyeRepositoryEntityType.class);
            for (EntityLink entity : entityLinksForProject) {
                if (!applinksInstance.getId().equals((Object)entity.getApplicationLink().getId())) continue;
                if (!existingRepos.contains(entity.getKey())) {
                    log.debug(String.format("Found new repository entity link [%s] in application link [%s]. Adding to fisheye repository store", entity.getKey(), applinksInstance));
                    this.fishEyeRepositoryStore.addRepository(entity.getKey(), oldInstance.getId());
                } else {
                    existingRepos.remove(entity.getKey());
                }
                log.debug(String.format("Associating entity link [%s] in project [%s] with fisheye repository [%s]", entity, project.getKey(), entity.getKey()));
                this.fishEyeRepositoryStore.associateProjectWithRepository(project.getKey(), entity.getKey(), oldInstance.getId());
            }
        }
        for (String repo : existingRepos) {
            FishEyeRepository fishEyeRepository = (FishEyeRepository)existingReposMap.get(repo);
            if (fishEyeRepository == null) continue;
            Collection<String> mappedProjects = fishEyeRepository.getMappedProjectKeys();
            for (String jiraProject : mappedProjects) {
                log.info("Creating repository entity link for jira project [{}] with fisheye repository [{}]", (Object)jiraProject, (Object)fishEyeRepository);
                this.addRepositoryEntity(applinksInstance, jiraProject, fishEyeRepository);
            }
        }
    }

    private boolean isAlreadyConfigured(ApplicationLink applicationLink) {
        for (Class<? extends AuthenticationProvider> provider : AUTHENTICATION_PROVIDERS) {
            if (!this.authConfigurationManager.isConfigured(applicationLink.getId(), provider)) continue;
            return true;
        }
        return false;
    }

    class TrustedAppsAuthenticationProviderConfiguration
    implements AuthenticationProviderConfiguration {
        TrustedAppsAuthenticationProviderConfiguration() {
        }

        @Override
        public boolean isApplicable(FishEyeInstance fishEyeInstance, ApplicationLink applicationLink) {
            return !UalUpgradeHelperImpl.this.isAlreadyConfigured(applicationLink) && StringUtils.isEmpty(fishEyeInstance.getUsername());
        }

        @Override
        public void configure(FishEyeInstance fisheyeInstance, ApplicationLink applicationLink) {
            if (!this.isApplicable(fisheyeInstance, applicationLink)) {
                log.error(String.format("The fisheye instance [%s] is not applicable for Trusted Apps Authentication", fisheyeInstance));
            } else {
                UalUpgradeHelperImpl.this.authConfigurationManager.registerProvider(applicationLink.getId(), TrustedAppsAuthenticationProvider.class, (Map)ImmutableMap.of());
            }
        }
    }

    class BasicAuthAuthenticationProviderConfiguration
    implements AuthenticationProviderConfiguration {
        static final String USERNAME_KEY = "username";
        static final String PASSWORD_KEY = "password";

        BasicAuthAuthenticationProviderConfiguration() {
        }

        @Override
        public boolean isApplicable(FishEyeInstance fishEyeInstance, ApplicationLink applicationLink) {
            boolean blankUsername = StringUtils.isBlank(fishEyeInstance.getUsername()) && StringUtils.isBlank(fishEyeInstance.getBasicHttpAuthUsername());
            return !UalUpgradeHelperImpl.this.isAlreadyConfigured(applicationLink) && !blankUsername;
        }

        @Override
        public void configure(FishEyeInstance fisheyeInstance, ApplicationLink applicationLink) {
            if (!this.isApplicable(fisheyeInstance, applicationLink)) {
                log.error(String.format("The fisheye instance [%s] is not applicable for Basic Authentication", fisheyeInstance));
            } else {
                UalUpgradeHelperImpl.this.authConfigurationManager.registerProvider(applicationLink.getId(), BasicAuthenticationProvider.class, this.getConfig(fisheyeInstance));
            }
        }

        private Map<String, String> getConfig(FishEyeInstance fisheyeInstance) {
            String username = fisheyeInstance.getUsername();
            String password = fisheyeInstance.getPassword();
            if (StringUtils.isBlank(username)) {
                log.info("FishEye username is not set for '{}', falling back to HTTP Basic Auth username", (Object)fisheyeInstance.getApiUrl());
                username = fisheyeInstance.getBasicHttpAuthUsername();
                password = fisheyeInstance.getBasicHttpAuthPassword();
            }
            return ImmutableMap.builder().put((Object)USERNAME_KEY, (Object)username).put((Object)PASSWORD_KEY, (Object)(password == null ? "" : password)).build();
        }
    }

    static interface AuthenticationProviderConfiguration {
        public boolean isApplicable(FishEyeInstance var1, ApplicationLink var2);

        public void configure(FishEyeInstance var1, ApplicationLink var2);
    }
}

