/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.ual;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.EntityLink;
import com.atlassian.applinks.api.EntityLinkService;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleProjectEntityType;
import com.atlassian.applinks.api.application.fecru.FishEyeRepositoryEntityType;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jirafisheyeplugin.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryManager;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual.ApplicationLinkIdMapper;
import com.atlassian.jirafisheyeplugin.upgrade.ual.FishEyePropertyEnumerator;
import com.atlassian.jirafisheyeplugin.upgrade.ual.MigrationInstanceProperty;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalFullMigrator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UalFullMigratorImpl
implements UalFullMigrator {
    private static final Logger log = LoggerFactory.getLogger(UalFullMigratorImpl.class);
    private final com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore legacyInstanceStore;
    private final FishEyeProperties fishEyeProperties;
    private final ApplicationLinkService applicationLinkService;
    private final ApplicationLinkIdMapper applicationLinkIdMapper;
    private final FishEyePropertyEnumerator fishEyePropertyEnumerator;
    private com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore legacyRepositoryStore;
    private ProjectManager projectManager;
    private EntityLinkService entityLinkService;
    private FishEyeRepositoryStore repositoryStore;
    private FishEyeRepositoryManager repositoryManager;
    private com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore legacyProjectStore;
    private CrucibleProjectStore crucibleProjectStore;
    private FishEyeInstanceStore instanceStore;

    public UalFullMigratorImpl(com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore legacyInstanceStore, FishEyeProperties fishEyeProperties, ApplicationLinkService applicationLinkService, ApplicationLinkIdMapper applicationLinkIdMapper, FishEyePropertyEnumerator fishEyePropertyEnumerator, com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore legacyRepositoryStore, ProjectManager projectManager, EntityLinkService entityLinkService, FishEyeRepositoryStore repositoryStore, FishEyeRepositoryManager repositoryManager, com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore legacyProjectStore, CrucibleProjectStore crucibleProjectStore, FishEyeInstanceStore instanceStore) {
        this.legacyInstanceStore = legacyInstanceStore;
        this.fishEyeProperties = fishEyeProperties;
        this.applicationLinkService = applicationLinkService;
        this.applicationLinkIdMapper = applicationLinkIdMapper;
        this.fishEyePropertyEnumerator = fishEyePropertyEnumerator;
        this.legacyRepositoryStore = legacyRepositoryStore;
        this.projectManager = projectManager;
        this.entityLinkService = entityLinkService;
        this.repositoryStore = repositoryStore;
        this.repositoryManager = repositoryManager;
        this.legacyProjectStore = legacyProjectStore;
        this.crucibleProjectStore = crucibleProjectStore;
        this.instanceStore = instanceStore;
    }

    @Override
    public void migrate() throws FishEyeUpgradeException {
        for (ApplicationLink applicationLink : this.applicationLinkService.getApplicationLinks(FishEyeCrucibleApplicationType.class)) {
            com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance fishEyeInstance = this.legacyInstanceStore.getFishEyeInstance(this.applicationLinkIdMapper.fromApplicationId(applicationLink.getId()));
            for (MigrationInstanceProperty migrationInstanceProperty : this.fishEyePropertyEnumerator.getPropertiesFor(fishEyeInstance)) {
                this.putPropertyInto(applicationLink, fishEyeInstance, migrationInstanceProperty);
            }
        }
    }

    @Override
    public void cleanOutOfSyncLinks() {
        HashMap jiraCrucibleEntityLinks = new HashMap();
        for (Project project : this.projectManager.getProjectObjects()) {
            Collection<com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository> repositories = this.legacyRepositoryStore.getRepositories(project.getKey());
            for (com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository fishEyeRepository : repositories) {
                this.legacyRepositoryStore.removeProjectFromRepository(project.getKey(), fishEyeRepository.getName(), fishEyeRepository.getInstance().getId());
            }
            ArrayList<String> repositoryNamesFromEntityLinks = new ArrayList<String>();
            for (EntityLink entityLink : this.entityLinkService.getEntityLinks((Object)project, FishEyeRepositoryEntityType.class)) {
                repositoryNamesFromEntityLinks.add(entityLink.getKey());
            }
            for (FishEyeRepository repository3 : this.repositoryStore.getRepositories(project.getKey())) {
                if (repositoryNamesFromEntityLinks.contains(repository3.getName())) continue;
                repository3.unMap(project);
                this.repositoryManager.update(repository3);
            }
            for (EntityLink entityLink : this.entityLinkService.getEntityLinks((Object)project, FishEyeCrucibleProjectEntityType.class)) {
                String key = entityLink.getApplicationLink().getId().get() + "." + entityLink.getKey();
                if (!jiraCrucibleEntityLinks.containsKey(key)) {
                    jiraCrucibleEntityLinks.put(key, new ArrayList());
                }
                ((List)jiraCrucibleEntityLinks.get(key)).add(project.getId());
            }
        }
        for (com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance fishEyeInstance : this.legacyInstanceStore.getAllFishEyeInstances()) {
            for (String cruProjKey : this.legacyProjectStore.getCrucibleProjectKeys(fishEyeInstance.getId())) {
                this.legacyProjectStore.setDefaultCrucibleProject(new ArrayList(), cruProjKey, fishEyeInstance.getId());
            }
        }
        for (FishEyeInstance fishEyeInstance : this.instanceStore.getAllFishEyeInstances()) {
            if (!fishEyeInstance.isCru()) continue;
            for (String cruProjKey : this.crucibleProjectStore.getCrucibleProjectKeys(fishEyeInstance.getApplicationId())) {
                List list = (List)jiraCrucibleEntityLinks.get(fishEyeInstance.getApplicationId().get() + "." + cruProjKey);
                this.crucibleProjectStore.setDefaultCrucibleProject(list == null ? new ArrayList() : list, cruProjKey, fishEyeInstance.getApplicationId());
            }
        }
    }

    private <T> void putPropertyInto(ApplicationLink applicationLink, com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance fishEyeInstance, MigrationInstanceProperty<T> property) {
        T value = property.getProperty(this.fishEyeProperties, fishEyeInstance);
        if (applicationLink.getProperty(property.getMigratedKey()) == null) {
            log.info(String.format("migrating fisheye property [%s] with value [%s] from instance [%s] to applicationlink [%s] with new key [%s]", property.getKey(), value, fishEyeInstance, applicationLink, property.getMigratedKey()));
            applicationLink.putProperty(property.getMigratedKey(), (Object)(value == null ? null : value.toString()));
        } else {
            log.info(String.format("property %s already exist on applicationlink %s with value %s", property.getMigratedKey(), applicationLink.getId(), applicationLink.getProperty(property.getMigratedKey())));
        }
    }
}

