/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.ual;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.ual.BooleanInstanceProperty;
import com.atlassian.jirafisheyeplugin.upgrade.ual.FishEyePropertyEnumerator;
import com.atlassian.jirafisheyeplugin.upgrade.ual.GlobalProperty;
import com.atlassian.jirafisheyeplugin.upgrade.ual.MigrationInstanceProperty;
import com.atlassian.jirafisheyeplugin.upgrade.ual.StringGlobalProperty;
import com.atlassian.jirafisheyeplugin.upgrade.ual.StringInstanceProperty;
import com.atlassian.jirafisheyeplugin.upgrade.ual.TextInstanceProperty;
import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.List;

public class FishEyePropertyEnumeratorImpl
implements FishEyePropertyEnumerator {
    private final FishEyeRepositoryStore fishEyeRepositoryStore;
    private final CrucibleProjectStore crucibleProjectStore;
    private final ProjectManager projectManager;

    public FishEyePropertyEnumeratorImpl(FishEyeRepositoryStore fishEyeRepositoryStore, CrucibleProjectStore crucibleProjectStore, ProjectManager projectManager) {
        this.fishEyeRepositoryStore = fishEyeRepositoryStore;
        this.crucibleProjectStore = crucibleProjectStore;
        this.projectManager = projectManager;
    }

    @Override
    public Iterable<? extends MigrationInstanceProperty> getPropertiesFor(FishEyeInstance fishEyeInstance) {
        return Iterables.concat((Iterable)Sets.union(FishEyePropertyKeys.INSTANCE_PROPERTIES, GlobalProperty.GLOBAL_PROPERTIES), this.getCruProjectPropertiesFor(fishEyeInstance), this.getRepositoryPropertiesFor(fishEyeInstance), this.getApplicationLinkPropertiesFor(fishEyeInstance));
    }

    private Iterable<? extends MigrationInstanceProperty> getApplicationLinkPropertiesFor(FishEyeInstance fishEyeInstance) {
        return Lists.newArrayList((Object[])new MigrationInstanceProperty[]{new TextInstanceProperty("ual.%APPLINKSID%.instance.id".replace("%APPLINKSID%", fishEyeInstance.getApplicationId().get())), new TextInstanceProperty("fisheye.applicationlink.id"), new BooleanInstanceProperty("fisheye.refreshed"){

            @Override
            public Boolean getProperty(FishEyeProperties properties, FishEyeInstance fishEyeInstance) {
                return true;
            }
        }});
    }

    private Iterable<? extends MigrationInstanceProperty> getCruProjectPropertiesFor(final FishEyeInstance fishEyeInstance) {
        Collection<String> crucibleProjectKeys = this.crucibleProjectStore.getCrucibleProjectKeys(fishEyeInstance.getId());
        return Iterables.concat((Iterable)Lists.newArrayList((Object[])new 2[]{new TextInstanceProperty("fisheye.crucible.projects.all." + fishEyeInstance.getId() + ".projects"){

            @Override
            public String getMigratedKey() {
                return FishEyePropertyKeys.CRUCIBLE_PROJECTS_ALL;
            }
        }}), (Iterable)Iterables.transform(crucibleProjectKeys, (Function)new Function<String, MigrationInstanceProperty>(){

            public MigrationInstanceProperty apply(String crucibleProjectKey) {
                return new TextInstanceProperty("fisheye.crucible." + crucibleProjectKey + ".projects");
            }
        }), (Iterable)Iterables.concat((Iterable)Iterables.transform(crucibleProjectKeys, (Function)new Function<String, Iterable<? extends MigrationInstanceProperty>>(){

            public Iterable<? extends MigrationInstanceProperty> apply(String crucibleProjectKey) {
                return Iterables.transform((Iterable)FishEyePropertyEnumeratorImpl.this.crucibleProjectStore.getMappedCrucibleProjectKeys(crucibleProjectKey, fishEyeInstance.getId()), (Function)new Function<String, MigrationInstanceProperty>(){

                    public MigrationInstanceProperty apply(String jiraProjectKey) {
                        return new StringInstanceProperty("fisheye.default.crucible.project." + jiraProjectKey);
                    }
                });
            }
        })));
    }

    private Iterable<? extends MigrationInstanceProperty> getRepositoryPropertiesFor(FishEyeInstance fishEyeInstance) {
        Collection<FishEyeRepository> repositoriesForInstance = this.fishEyeRepositoryStore.getRepositoriesForInstance(fishEyeInstance.getId());
        List jiraProjectKeys = this.projectManager.getProjectObjects();
        return Iterables.concat((Iterable)Iterables.transform(repositoriesForInstance, (Function)new Function<FishEyeRepository, MigrationInstanceProperty>(){

            public MigrationInstanceProperty apply(FishEyeRepository fishEyeRepository) {
                return new TextInstanceProperty("fisheye.rep." + fishEyeRepository.getName() + ".projects");
            }
        }), (Iterable)Iterables.transform((Iterable)jiraProjectKeys, (Function)new Function<Project, MigrationInstanceProperty>(){

            public MigrationInstanceProperty apply(Project jiraProject) {
                return new StringGlobalProperty("fisheye." + jiraProject.getKey() + ".repository.instance");
            }
        }), (Iterable)Iterables.transform((Iterable)jiraProjectKeys, (Function)new Function<Project, MigrationInstanceProperty>(){

            public MigrationInstanceProperty apply(Project jiraProject) {
                return new StringGlobalProperty("fisheye." + jiraProject.getKey() + ".repository");
            }
        }), (Iterable)Iterables.transform((Iterable)jiraProjectKeys, (Function)new Function<Project, MigrationInstanceProperty>(){

            public MigrationInstanceProperty apply(Project jiraProject) {
                return new StringGlobalProperty("fisheye." + jiraProject.getKey() + ".repository.path");
            }
        }));
    }
}

