/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.ual;

import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.ual.CrucibleEnabledPropertyFixup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrucibleEnabledPropertyFixupTask
implements FishEyeUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(CrucibleEnabledPropertyFixupTask.class);
    private static final String CRUCIBLE_ENABLED_PROPERTY_FIX_TASK_COMPLETE = "fisheye.ual.crucible.enabled.property.fix.complete";
    private final CrucibleEnabledPropertyFixup crucibleEnabledPropertyFixup;
    private final FishEyeProperties fisheyeProperties;

    public CrucibleEnabledPropertyFixupTask(CrucibleEnabledPropertyFixup crucibleEnabledPropertyFixup, FishEyeProperties fisheyeProperties) {
        this.crucibleEnabledPropertyFixup = crucibleEnabledPropertyFixup;
        this.fisheyeProperties = fisheyeProperties;
    }

    @Override
    public String getName() {
        return "Crucible Enabled Property Fixup Task";
    }

    @Override
    public boolean isNeeded() {
        return this.fisheyeProperties.getBoolean(CRUCIBLE_ENABLED_PROPERTY_FIX_TASK_COMPLETE) == null;
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        this.crucibleEnabledPropertyFixup.fix();
        this.fisheyeProperties.setBoolean(CRUCIBLE_ENABLED_PROPERTY_FIX_TASK_COMPLETE, true);
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

