/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.ual;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.jirafisheyeplugin.config.fisheye.FishEyeInstanceStoreImpl;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual.ApplicationLinkIdMapperImpl;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.ual.CrucibleEnabledPropertyFixup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrucibleEnabledPropertyFixupImpl
implements CrucibleEnabledPropertyFixup {
    private static final Logger log = LoggerFactory.getLogger(CrucibleEnabledPropertyFixupImpl.class);
    private final ApplicationLinkService applicationLinkService;
    private final FishEyeInstanceStore fishEyeInstanceStore;
    private final ApplicationLinkIdMapperImpl applicationLinkIdMapper;

    public CrucibleEnabledPropertyFixupImpl(ApplicationLinkService applicationLinkService, FishEyeInstanceStore fishEyeInstanceStore, ApplicationLinkIdMapperImpl applicationLinkIdMapper) {
        this.applicationLinkService = applicationLinkService;
        this.fishEyeInstanceStore = fishEyeInstanceStore;
        this.applicationLinkIdMapper = applicationLinkIdMapper;
    }

    @Override
    public void fix() throws FishEyeUpgradeException {
        for (ApplicationLink applicationLink : this.applicationLinkService.getApplicationLinks(FishEyeCrucibleApplicationType.class)) {
            String key = "fisheye.crucible.enabled";
            try {
                FishEyeInstanceStoreImpl.CrucibleEnabledState value = FishEyeInstanceStoreImpl.CrucibleEnabledState.valueOf((String)applicationLink.getProperty(key));
                log.info(String.format("Property {%s}->{%s} does not require fixing.", key, value.name()));
            }
            catch (IllegalArgumentException e) {
                log.info(String.format("Found incorrectly migrated property {%s}->{%s}, fixing...", key, (String)applicationLink.getProperty(key)));
                FishEyeInstance fishEyeInstance = this.fishEyeInstanceStore.getFishEyeInstance(this.applicationLinkIdMapper.fromApplicationId(applicationLink.getId()));
                applicationLink.putProperty(key, (Object)this.computeCrucibleState(fishEyeInstance).name());
                log.info(String.format("Fix completed : {%s}->{%s}", key, (String)applicationLink.getProperty(key)));
            }
        }
    }

    private FishEyeInstanceStoreImpl.CrucibleEnabledState computeCrucibleState(FishEyeInstance fishEyeInstance) {
        boolean isCrucible = fishEyeInstance.isCru();
        boolean isStandalone = fishEyeInstance.isCruStandalone();
        return isCrucible ? (isStandalone ? FishEyeInstanceStoreImpl.CrucibleEnabledState.STANDALONE : FishEyeInstanceStoreImpl.CrucibleEnabledState.ENABLED) : FishEyeInstanceStoreImpl.CrucibleEnabledState.DISABLED;
    }
}

