/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks.ual;

import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalCheckBypass;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalUpgrader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UalUpgradeTask
implements FishEyeUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UalUpgradeTask.class);
    public static final String UAL_UPGRADE_TASK_NAME = "Upgrade to UAL";
    private final UalCheckBypass ualCheckBypass;
    private final UalUpgrader ualUpgrader;

    public UalUpgradeTask(UalCheckBypass ualCheckBypass, UalUpgrader ualUpgrader) {
        this.ualCheckBypass = ualCheckBypass;
        this.ualUpgrader = ualUpgrader;
    }

    @Override
    public String getName() {
        return UAL_UPGRADE_TASK_NAME;
    }

    @Override
    public boolean isNeeded() {
        return this.ualUpgrader.isUpgradeNeeded();
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        log.info("Starting Application Link Upgrade...");
        this.ualCheckBypass.withNoCheck(new UalCheckBypass.Closure<FishEyeUpgradeException>(){

            @Override
            public void execute() throws FishEyeUpgradeException {
                UalUpgradeTask.this.ualUpgrader.performUpgrade();
            }
        });
        log.info("Completed Application Link Upgrade.");
    }
}

