/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks.ual;

import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalFullMigrator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UalFullMigrationTask
implements FishEyeUpgradeTask {
    private static final Logger log = LoggerFactory.getLogger(UalFullMigrationTask.class);
    public static final String FISHEYE_UAL_MIGRATION_COMPLETE = "fisheye.ual.migration.complete";
    private final UalFullMigrator ualFullMigrator;
    private final FishEyeProperties fishEyeProperties;

    public UalFullMigrationTask(UalFullMigrator ualFullMigrator, FishEyeProperties fishEyeProperties) {
        this.ualFullMigrator = ualFullMigrator;
        this.fishEyeProperties = fishEyeProperties;
    }

    @Override
    public String getName() {
        return "Upgrade task to fully migrate to UAL";
    }

    @Override
    public boolean isNeeded() {
        return this.fishEyeProperties.getBoolean(FISHEYE_UAL_MIGRATION_COMPLETE) == null;
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        log.info("Starting full UAL migration");
        this.ualFullMigrator.migrate();
        this.fishEyeProperties.setBoolean(FISHEYE_UAL_MIGRATION_COMPLETE, true);
        log.info("completed full UAL migration");
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

