/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce;

import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfig;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigImpl;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerforceUpgradeToMultipleInstanceFormatTask
implements FishEyeUpgradeTask,
FishEyePropertyKeys {
    private static Logger log = LoggerFactory.getLogger(PerforceUpgradeToMultipleInstanceFormatTask.class);
    private final PerforceConfigStore perforceConfigStore;
    private final FishEyeProperties fisheyeProperties;
    private final ProjectManager projectManager;
    private final PerforceProperties perforceProperties;
    private final JiraHome jiraHome;
    private final AttachmentPathManager attachmentPathManager;

    public PerforceUpgradeToMultipleInstanceFormatTask(PerforceConfigStore perforceConfigStore, FishEyeProperties fisheyeProperties, ProjectManager projectManager, PerforceProperties perforceProperties, JiraHome jiraHome, AttachmentPathManager attachmentPathManager) {
        this.perforceConfigStore = perforceConfigStore;
        this.fisheyeProperties = fisheyeProperties;
        this.projectManager = projectManager;
        this.perforceProperties = perforceProperties;
        this.jiraHome = jiraHome;
        this.attachmentPathManager = attachmentPathManager;
    }

    @Override
    public String getName() {
        return "Upgrade single Perforce instance configuration to multiple Perforce configuration";
    }

    @Override
    public boolean isNeeded() {
        return this.perforceConfigStore.getDefaultConfig() == null && "1".equals(this.fisheyeProperties.getString("fisheye.p4.enabled"));
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        log.info("Constructing upgraded Perforce config...");
        PerforceConfig config = new PerforceConfigImpl(null, this.p("fisheye.p4.text.port"), this.p("fisheye.p4.text.executable"), this.p("fisheye.p4.user"), this.p("fisheye.p4.password"), this.p("fisheye.p4.client"), this.fisheyeProperties.getLong("fisheye.p4.timeout"), this.p("fisheye.p4.charset"), this.p("fisheye.p4.text.ticketfile"), this.p("fisheye.p4.loglevel"), this.p("fisheye.p4.sysdrive"), this.p("fisheye.p4.text.sysroot"), this.p("fisheye.p4.text.url.jobview"), this.fisheyeProperties.getMap("fisheye.p4.custom.fields"), this.jiraHome, this.perforceProperties, this.attachmentPathManager);
        log.info("Saving upgraded Perforce config...");
        this.perforceConfigStore.saveConfig(config);
        log.info("Reloading config...");
        config = this.perforceConfigStore.getDefaultConfig();
        if (config == null) {
            throw new FishEyeUpgradeException("Failed to save and reload Perforce configuration.");
        }
        log.info("Associating all projects with new Perforce config...");
        Collection jiraProjectKeys = Collections2.transform((Collection)this.projectManager.getProjectObjects(), (Function)new Function<Project, String>(){

            public String apply(Project project) {
                return project.getKey();
            }
        });
        this.perforceConfigStore.associateProjectKeysWithConfig(jiraProjectKeys, config);
        log.info("Deleting old Perforce properties...");
        this.r("fisheye.p4.enabled");
        this.r("fisheye.p4.text.port");
        this.r("fisheye.p4.text.executable");
        this.r("fisheye.p4.user");
        this.r("fisheye.p4.password");
        this.r("fisheye.p4.client");
        this.r("fisheye.p4.timeout");
        this.r("fisheye.p4.charset");
        this.r("fisheye.p4.text.ticketfile");
        this.r("fisheye.p4.loglevel");
        this.r("fisheye.p4.sysdrive");
        this.r("fisheye.p4.text.sysroot");
        this.r("fisheye.p4.text.url.jobview");
        this.r("fisheye.p4.custom.fields");
    }

    private String p(String key) {
        return this.fisheyeProperties.getString(key);
    }

    private void r(String key) {
        this.fisheyeProperties.removeProperty(key);
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

