/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jirafisheyeplugin.perforce.workflow.CreateJobFunction;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.AbstractWorkflowUpgradeTask;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.FunctionDescriptor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerforceUpdateCreateJobFunctionTask
extends AbstractWorkflowUpgradeTask {
    private static Logger log = LoggerFactory.getLogger(PerforceUpdateCreateJobFunctionTask.class);
    protected static final List<String> OLD_CLASSNAMES = Arrays.asList("com.atlassian.jira.plugin.ext.perforce.workflow.CreateJobFunction", "com.atlassian.jira.ext.fisheye.perforce.workflow.CreateJobFunction");
    protected static final String NEW_CLASSNAME = CreateJobFunction.class.getName();
    private final String UPGRADE_APPLIED = "Perforce Update Applied";

    public PerforceUpdateCreateJobFunctionTask(WorkflowManager workflowManager, FishEyeProperties properties) {
        super(workflowManager, properties);
    }

    @Override
    public String getName() {
        return "Update CreateJobFunction Namespace";
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected boolean upgradeWorkflow(JiraWorkflow workflow, boolean isSystemWorkflow) {
        boolean workflowUpdated = false;
        Iterator transitions = workflow.getAllActions().iterator();
        while (transitions.hasNext()) {
            boolean addUpdatedFunction = false;
            boolean hasDisplayedMergeWarning = false;
            boolean isUpdatedFunctionAlreadyPresent = false;
            int functionIndex = 0;
            Integer removedFunctionPosition = null;
            ActionDescriptor actionDescriptor = (ActionDescriptor)transitions.next();
            Iterator postFunctions = actionDescriptor.getUnconditionalResult().getPostFunctions().iterator();
            while (postFunctions.hasNext()) {
                FunctionDescriptor descriptor = (FunctionDescriptor)postFunctions.next();
                String className = (String)descriptor.getArgs().get("class.name");
                if (NEW_CLASSNAME.equals(className)) {
                    isUpdatedFunctionAlreadyPresent = true;
                }
                if (OLD_CLASSNAMES.contains(className)) {
                    if (isSystemWorkflow) {
                        this.logError("Detected reference to Create Job Post-Function in filesystem-configured workflow '" + workflow.getName() + "' for transition '" + actionDescriptor.getName() + "'. Please manually upgrade the configuration for this workflow by updating the post-function <arg name=\"class.name\" /> elements containing '" + className + "' to the new namespace: '" + NEW_CLASSNAME + "'.");
                    } else {
                        this.logInfo("Removing old Create Job post-function from workflow transition '" + actionDescriptor.getName() + "'");
                        postFunctions.remove();
                        if (addUpdatedFunction && !hasDisplayedMergeWarning) {
                            this.logWarn("More than one old Create Job post-function was defined for workflow transition '" + actionDescriptor.getName() + "' - they will be merged into ONE post-function under the new namespace.");
                            hasDisplayedMergeWarning = true;
                        }
                        addUpdatedFunction = true;
                        if (removedFunctionPosition == null) {
                            removedFunctionPosition = new Integer(functionIndex);
                        }
                    }
                }
                ++functionIndex;
            }
            if (!addUpdatedFunction) continue;
            if (isUpdatedFunctionAlreadyPresent) {
                this.logInfo("Workflow transition '" + actionDescriptor.getName() + "' already contains Create Job post-function from previous upgrade attempt. Not adding another.");
            } else {
                this.logInfo("Adding new Create Job post-function to workflow transition '" + actionDescriptor.getName() + "'");
                int positionInList = removedFunctionPosition == null ? 0 : removedFunctionPosition;
                actionDescriptor.getUnconditionalResult().getPostFunctions().add(positionInList, this.makeDescriptor());
            }
            workflowUpdated = true;
        }
        return workflowUpdated;
    }

    @Override
    protected String getUpgradeString() {
        return "Perforce Update Applied";
    }

    protected FunctionDescriptor makeDescriptor() {
        return CreateJobFunction.makeDescriptor();
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

