/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce;

import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerforceRemoveOldJobUpdateListenerTask
implements FishEyeUpgradeTask {
    private static Logger log = LoggerFactory.getLogger(PerforceRemoveOldJobUpdateListenerTask.class);
    private static final List<String> OLD_LISTENER_CLASSES = Arrays.asList("com.atlassian.jira.plugin.ext.perforce.listener.JobUpdateListener", "com.atlassian.jira.ext.fisheye.perforce.listener.JobUpdateListener");
    private ListenerManager listenerManager;
    private OfBizDelegator delegator;

    public PerforceRemoveOldJobUpdateListenerTask(ListenerManager listenerManager, OfBizDelegator delegator) {
        this.listenerManager = listenerManager;
        this.delegator = delegator;
    }

    @Override
    public String getName() {
        return "Remove old Perforce Job Update Listener";
    }

    @Override
    public boolean isNeeded() {
        return true;
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        ArrayList<EntityExpr> conditions = new ArrayList<EntityExpr>();
        for (String oldValue : OLD_LISTENER_CLASSES) {
            conditions.add(new EntityExpr("clazz", EntityOperator.EQUALS, (Object)oldValue));
        }
        try {
            List oldListeners = this.delegator.findByOr("ListenerConfig", conditions, Collections.emptyList());
            for (GenericValue gv : oldListeners) {
                int result = this.delegator.removeValue(gv);
                if (result <= 0) continue;
                this.listenerManager.refresh();
                log.info("Removed old Perforce Job Update listener");
            }
        }
        catch (DataAccessException e) {
            log.error("Could not remove old Perforce Job Update listener: ", (Throwable)e);
        }
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

