/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce;

import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PerforceRemoveChangesIndexingServiceTask
implements FishEyeUpgradeTask {
    private static final String SERVICE_NAME = "Perforce Changes Indexing Service";
    private static Logger log = LoggerFactory.getLogger(PerforceRemoveChangesIndexingServiceTask.class);
    private ServiceManager serviceManager;

    public PerforceRemoveChangesIndexingServiceTask(ServiceManager serviceManager) {
        this.serviceManager = serviceManager;
    }

    @Override
    public String getName() {
        return "Remove Perforce Changes Indexing Service";
    }

    @Override
    public boolean isNeeded() {
        return true;
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        try {
            if (this.serviceManager.getServiceWithName(SERVICE_NAME) != null) {
                try {
                    log.info("Removing old Perforce Changes Indexing Service");
                    this.serviceManager.removeServiceByName(SERVICE_NAME);
                    this.serviceManager.refreshAll();
                }
                catch (Exception e) {
                    log.error("Exception encountered whilst trying to remove service 'Perforce Changes Indexing Service'", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            log.error("Error resolving service with name Perforce Changes Indexing Service", (Throwable)e);
        }
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

