/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce;

import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPerforceCFNamespaceUpdateTask
implements FishEyeUpgradeTask {
    private static Logger log = LoggerFactory.getLogger(AbstractPerforceCFNamespaceUpdateTask.class);
    protected static final String CF_ENTITY = "CustomField";
    protected static final String CF_TYPE_KEY = "customfieldtypekey";
    protected static final String CF_SEARCHER_KEY = "customfieldsearcherkey";
    private boolean updateWasPerformed = false;
    private OfBizDelegator delegator;

    public AbstractPerforceCFNamespaceUpdateTask(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public boolean isNeeded() {
        return true;
    }

    @Override
    public void doUpgrade() {
        ArrayList<EntityExpr> conditions = new ArrayList<EntityExpr>();
        for (String oldValue : this.getOldValues()) {
            conditions.add(new EntityExpr(this.getFieldName(), EntityOperator.EQUALS, (Object)oldValue));
        }
        List customFields = this.delegator.findByOr(CF_ENTITY, conditions, Collections.emptyList());
        for (GenericValue customField : customFields) {
            Long id = null;
            try {
                id = customField.getLong("id");
                log.info("Upgrading Perforce Job " + this.getFieldName() + ": '" + customField.getString("name") + "'");
                customField.setString(this.getFieldName(), this.getNewValue());
                customField.store();
                this.updateWasPerformed = true;
            }
            catch (GenericEntityException e) {
                log.error("Failed to update namespace of CustomField id=" + id, (Throwable)e);
            }
            catch (DataAccessException e) {
                log.error("Failed to update namespace of CustomField id=" + id, (Throwable)e);
            }
        }
    }

    @Override
    public boolean reindexRequired() {
        return this.updateWasPerformed;
    }

    protected abstract String getFieldName();

    protected abstract List<String> getOldValues();

    protected abstract String getNewValue();
}

