/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateRecentCommitsPropertyTask
implements FishEyeUpgradeTask {
    private static Logger log = LoggerFactory.getLogger(UpdateRecentCommitsPropertyTask.class);
    protected static final String PORTLET_CONFIG_ENTITY = "PortletConfiguration";
    protected static final String PORTLET_ENTITY_ID = "id";
    protected static final String PORTLET_ID = "portletId";
    protected static final String PROPERTY_ENTRY_ENTITY = "OSPropertyEntry";
    protected static final String PROPERTY_ENTITY_ID = "entityId";
    protected static final String PROPERTY_KEY = "propertyKey";
    private static final String ORIGINAL_PROPERTY_KEY = "branch";
    private static final String UPDATED_PROPERTY_KEY = "path";
    private static final String PORTLET_NAMESPACE = "com.atlassian.jira.ext.fisheye:fisheyerecentcommits";
    private OfBizDelegator delegator;

    public UpdateRecentCommitsPropertyTask(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public boolean isNeeded() {
        return true;
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        EntityExpr condition = new EntityExpr(PORTLET_ID, EntityOperator.EQUALS, (Object)PORTLET_NAMESPACE);
        List recentCommitPortletIds = this.delegator.findByCondition(PORTLET_CONFIG_ENTITY, (EntityCondition)condition, (Collection)EasyList.build((Object)PORTLET_ENTITY_ID), null);
        Iterator iterator = recentCommitPortletIds.iterator();
        while (iterator.hasNext()) {
            Long id = null;
            try {
                GenericValue portletIdGv = (GenericValue)iterator.next();
                id = portletIdGv.getLong(PORTLET_ENTITY_ID);
                List props = this.delegator.findByAnd(PROPERTY_ENTRY_ENTITY, EasyMap.build((Object)PROPERTY_ENTITY_ID, (Object)id, (Object)PROPERTY_KEY, (Object)ORIGINAL_PROPERTY_KEY));
                for (GenericValue propGv : props) {
                    propGv.setString(PROPERTY_KEY, UPDATED_PROPERTY_KEY);
                    propGv.store();
                }
            }
            catch (GenericEntityException e) {
                log.error("Failed to update OSPropertyEntry(s) for portlet id=" + id, (Throwable)e);
            }
            catch (DataAccessException e) {
                log.error("Failed to update OSPropertyEntry(s) for portlet id=" + id, (Throwable)e);
            }
        }
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }

    @Override
    public String getName() {
        return "Upgrade Recent Commits Portlet Path property";
    }
}

