/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.core.util.map.EasyMap;
import com.atlassian.jira.exception.DataAccessException;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.EntityUtil;
import org.ofbiz.core.entity.GenericEntityException;
import org.ofbiz.core.entity.GenericValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatePortletNamespaceTask
implements FishEyeUpgradeTask {
    private static Logger log = LoggerFactory.getLogger(UpdatePortletNamespaceTask.class);
    private static final String PORTLET_ENTITY = "PortletConfiguration";
    private static final String PORTLET_ID = "portletId";
    private static final String OLD_NAMESPACE = "com.cenqua.fisheye.jira:fisheyerecentcommits";
    private static final String NEW_NAMESPACE = "com.atlassian.jira.ext.fisheye:fisheyerecentcommits";
    private OfBizDelegator delegator;

    public UpdatePortletNamespaceTask(OfBizDelegator delegator) {
        this.delegator = delegator;
    }

    @Override
    public boolean isNeeded() {
        return true;
    }

    @Override
    public String getName() {
        return "Upgrade Recent Commits Portlet namespace";
    }

    protected String getEntityName() {
        return PORTLET_ENTITY;
    }

    @Override
    public void doUpgrade() {
        EntityExpr condition = new EntityExpr(PORTLET_ID, EntityOperator.EQUALS, (Object)OLD_NAMESPACE);
        List portletIds = this.delegator.findByCondition(PORTLET_ENTITY, (EntityCondition)condition, (Collection)EasyList.build((Object)"id"), null);
        Iterator iterator = portletIds.iterator();
        while (iterator.hasNext()) {
            Long id = null;
            try {
                GenericValue portletIdGv = (GenericValue)iterator.next();
                id = portletIdGv.getLong("id");
                GenericValue gv = EntityUtil.getOnly((List)this.delegator.findByAnd(PORTLET_ENTITY, EasyMap.build((Object)"id", (Object)id)));
                gv.setString(PORTLET_ID, NEW_NAMESPACE);
                gv.store();
            }
            catch (GenericEntityException e) {
                log.error("Failed to update namespace of PortletConfiguration id=" + id, (Throwable)e);
            }
            catch (DataAccessException e) {
                log.error("Failed to update namespace of PortletConfiguration id=" + id, (Throwable)e);
            }
        }
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

