/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jirafisheyeplugin.domain.workflow.condition.CodeCommittedCondition;
import com.atlassian.jirafisheyeplugin.domain.workflow.condition.ReviewsCompleteCondition;
import com.atlassian.jirafisheyeplugin.domain.workflow.condition.UnreviewedCodeCondition;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.AbstractWorkflowUpgradeTask;
import com.opensymphony.workflow.loader.ActionDescriptor;
import com.opensymphony.workflow.loader.ConditionDescriptor;
import com.opensymphony.workflow.loader.ConditionsDescriptor;
import com.opensymphony.workflow.loader.RestrictionDescriptor;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateConditionsToPlugins2NamespaceTask
extends AbstractWorkflowUpgradeTask {
    private static Logger log = LoggerFactory.getLogger(UpdateConditionsToPlugins2NamespaceTask.class);
    private static Map<String, String> CLASSNAMES = new HashMap<String, String>();
    private static final String ARG_CLASSNAME = "class.name";
    private final String UPGRADE_APPLIED = "Upgrade Conditions Applied";

    public UpdateConditionsToPlugins2NamespaceTask(WorkflowManager workflowManager, FishEyeProperties properties) {
        super(workflowManager, properties);
    }

    @Override
    public String getName() {
        return "Update To Plugins2 Namespace";
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected boolean upgradeWorkflow(JiraWorkflow workflow, boolean isSystemWorkflow) {
        boolean updated = false;
        for (ActionDescriptor action : workflow.getAllActions()) {
            RestrictionDescriptor restrictionDescriptor = action.getRestriction();
            if (restrictionDescriptor == null || restrictionDescriptor.getConditionsDescriptor() == null) continue;
            updated = this.upgradeConditions(action.getRestriction().getConditionsDescriptor(), action, workflow, isSystemWorkflow) || updated;
        }
        return updated;
    }

    @Override
    protected String getUpgradeString() {
        return "Upgrade Conditions Applied";
    }

    protected boolean upgradeConditions(ConditionsDescriptor conditionsDescriptor, ActionDescriptor action, JiraWorkflow workflow, boolean isSystemWorkflow) {
        boolean updated = false;
        for (Object node : conditionsDescriptor.getConditions()) {
            if (node instanceof ConditionsDescriptor) {
                updated = this.upgradeConditions((ConditionsDescriptor)node, action, workflow, isSystemWorkflow) || updated;
                continue;
            }
            if (node instanceof ConditionDescriptor) {
                ConditionDescriptor condition = (ConditionDescriptor)node;
                String descriptorClassName = (String)condition.getArgs().get(ARG_CLASSNAME);
                updated = this.upgradeCondition(condition, action, workflow, isSystemWorkflow, descriptorClassName);
                continue;
            }
            log.debug("Unexpected child of ConditionsDescriptor: " + (node == null ? "null" : node.getClass()));
        }
        return updated;
    }

    private boolean upgradeCondition(ConditionDescriptor condition, ActionDescriptor action, JiraWorkflow workflow, boolean isSystemWorkflow, String descriptorClassName) {
        String updatedClassName;
        boolean updated = false;
        if (descriptorClassName != null && (updatedClassName = CLASSNAMES.get(descriptorClassName)) != null) {
            if (isSystemWorkflow) {
                this.logError(String.format("Detected reference to a workflow condition in the filesystem-configured workflow '%s' for transition '%s'. Please manually upgrade the configuration for this workflow by updating the condition <arg name=\"class.name\" /> elements containing '%s' to the new namespace: '%s'.", workflow.getName(), action.getName(), descriptorClassName, updatedClassName));
            } else {
                log.debug(String.format("Upgrading '%s' condition class to '%s' (in workflow '%s' under action '%s')", descriptorClassName, updatedClassName, workflow.getName(), action.getName()));
                condition.getArgs().put(ARG_CLASSNAME, updatedClassName);
                updated = true;
            }
        }
        return updated;
    }

    static {
        CLASSNAMES.put("com.atlassian.jira.workflow.condition.ReviewsCompleteCondition", ReviewsCompleteCondition.class.getName());
        CLASSNAMES.put("com.atlassian.jira.workflow.condition.CodeCommittedCondition", CodeCommittedCondition.class.getName());
        CLASSNAMES.put("com.atlassian.jira.workflow.condition.UnreviewedCodeCondition", UnreviewedCodeCondition.class.getName());
        CLASSNAMES.put("com.atlassian.jirafisheyeplugin.workflow.condition.ReviewsCompleteCondition", ReviewsCompleteCondition.class.getName());
        CLASSNAMES.put("com.atlassian.jirafisheyeplugin.workflow.condition.CodeCommittedCondition", CodeCommittedCondition.class.getName());
        CLASSNAMES.put("com.atlassian.jirafisheyeplugin.workflow.condition.UnreviewedCodeCondition", UnreviewedCodeCondition.class.getName());
    }
}

