/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks;

import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;

public class UpdateApiUrlPropertyTask
implements FishEyeUpgradeTask,
FishEyePropertyKeys {
    private final String UPGRADE_APPLIED = "FISH-375-fixed";
    private final FishEyeProperties properties;

    public UpdateApiUrlPropertyTask(FishEyeProperties properties) {
        this.properties = properties;
    }

    @Override
    public String getName() {
        return "Upgrade API Url field (fix for FISH-374)";
    }

    @Override
    public boolean isNeeded() {
        return !this.properties.getBooleanPrimitive("FISH-375-fixed");
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        this.upgradeApiUrl(null);
        for (String id : this.properties.getCollection("fisheye.instance.list")) {
            this.upgradeApiUrl(new Integer(id));
        }
        this.properties.setBoolean("FISH-375-fixed", true);
    }

    private void upgradeApiUrl(Integer id) {
        String apiUrl = this.properties.getText("fisheye.text.api.url", id);
        if (apiUrl != null) {
            if (apiUrl.endsWith("/api")) {
                apiUrl = apiUrl.substring(0, apiUrl.length() - 3);
            } else if (apiUrl.endsWith("/api/")) {
                apiUrl = apiUrl.substring(0, apiUrl.length() - 4);
            }
            this.properties.setText("fisheye.text.api.url", apiUrl, id);
        }
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }
}

