/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks;

import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStoreImpl;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.DeprecatedFishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertiesImpl;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;
import java.util.Collection;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringToTextPropertyUpgradeTask
implements FishEyeUpgradeTask,
FishEyePropertyKeys,
DeprecatedFishEyePropertyKeys {
    private static Logger log = LoggerFactory.getLogger(StringToTextPropertyUpgradeTask.class);
    private FishEyeProperties properties;

    public StringToTextPropertyUpgradeTask(FishEyeProperties properties) {
        this.properties = properties;
    }

    @Override
    public String getName() {
        return "Convert long String properties to Text properties";
    }

    @Override
    public boolean isNeeded() {
        return true;
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }

    @Override
    public void doUpgrade() {
        this.convertToTextProperty("fisheye.replist", "fisheye.repository.list");
        this.upgradePropertiesForFishEyeInstance(null);
        Collection<String> instanceIds = this.properties.getCollection("fisheye.instance.list");
        Iterator<String> iterator = instanceIds.iterator();
        while (iterator.hasNext()) {
            Integer instanceId = new Integer(iterator.next());
            this.upgradePropertiesForFishEyeInstance(instanceId);
        }
        this.upgradePropertiesForPerforceConfiguration(null);
        Collection<String> p4CfgIds = this.properties.getCollection("fisheye.p4.configs");
        Iterator<String> iterator2 = p4CfgIds.iterator();
        while (iterator2.hasNext()) {
            Integer p4CfgId = new Integer(iterator2.next());
            this.upgradePropertiesForPerforceConfiguration(p4CfgId);
        }
    }

    private void upgradePropertiesForPerforceConfiguration(Integer p4CfgId) {
        this.convertToPerforceTextProperty("fisheye.p4.sysroot", "fisheye.p4.text.sysroot", p4CfgId);
        this.convertToPerforceTextProperty("fisheye.p4.executable", "fisheye.p4.text.executable", p4CfgId);
        this.convertToPerforceTextProperty("fisheye.p4.port", "fisheye.p4.text.port", p4CfgId);
        this.convertToPerforceTextProperty("fisheye.p4.ticketfile", "fisheye.p4.text.ticketfile", p4CfgId);
        this.convertToPerforceTextProperty("fisheye.p4.url.jobview", "fisheye.p4.text.url.jobview", p4CfgId);
    }

    private void upgradePropertiesForFishEyeInstance(Integer instanceId) {
        this.convertToFishEyeTextProperty("fisheye.api.url", "fisheye.text.api.url", instanceId);
        this.convertToFishEyeTextProperty("fisheye.url", "fisheye.text.url", instanceId);
        Collection<String> reps = this.properties.getCollection("fisheye.repository.list", instanceId);
        for (String repName : reps) {
            this.convertToFishEyeTextProperty("fisheye." + repName + ".projects", "fisheye.rep." + repName + ".projects", instanceId);
        }
    }

    private void convertToFishEyeTextProperty(String oldStringPropertyKey, String newTextPropertyKey, Integer instanceId) {
        this.convertToTextProperty(this.updateFishEyeInstanceKey(oldStringPropertyKey, instanceId), this.updateFishEyeInstanceKey(newTextPropertyKey, instanceId));
    }

    private void convertToPerforceTextProperty(String oldStringPropertyKey, String newTextPropertyKey, Integer instanceId) {
        this.convertToTextProperty(this.updatePerforceConfigurationKey(oldStringPropertyKey, instanceId), this.updatePerforceConfigurationKey(newTextPropertyKey, instanceId));
    }

    private void convertToTextProperty(String oldStringPropertyKey, String newTextPropertyKey) {
        boolean textPropertySet;
        String stringProperty = this.properties.getString(oldStringPropertyKey);
        String textProperty = this.properties.getText(newTextPropertyKey);
        boolean stringPropertySet = stringProperty != null;
        boolean bl = textPropertySet = textProperty != null;
        if (!stringPropertySet) {
            return;
        }
        if (textPropertySet) {
            if (stringProperty.equals(textProperty)) {
                log.warn("Duplicate STRING (" + oldStringPropertyKey + ") and TEXT (" + newTextPropertyKey + ") properties set - deleting deprecated " + oldStringPropertyKey + " property.");
                this.properties.removeProperty(oldStringPropertyKey);
            } else {
                log.warn("Different STRING (" + oldStringPropertyKey + ") and TEXT (" + newTextPropertyKey + ") properties set - will not upgrade.");
            }
            return;
        }
        this.properties.setText(newTextPropertyKey, stringProperty);
        this.properties.removeProperty(oldStringPropertyKey);
    }

    private String updateFishEyeInstanceKey(String key, Integer id) {
        return FishEyePropertiesImpl.updateKey(key, id);
    }

    private String updatePerforceConfigurationKey(String key, Integer id) {
        if (id == null) {
            return key;
        }
        return PerforceConfigStoreImpl.updateKey(key, id);
    }
}

