/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.tasks;

import com.atlassian.jira.workflow.JiraWorkflow;
import com.atlassian.jira.workflow.WorkflowException;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import org.slf4j.Logger;

public abstract class AbstractWorkflowUpgradeTask
implements FishEyeUpgradeTask {
    private final FishEyeProperties properties;
    protected final WorkflowManager workflowManager;

    protected AbstractWorkflowUpgradeTask(WorkflowManager workflowManager, FishEyeProperties properties) {
        this.workflowManager = workflowManager;
        this.properties = properties;
    }

    @Override
    public boolean isNeeded() {
        return !this.properties.getBooleanPrimitive(this.getUpgradeString());
    }

    @Override
    public boolean reindexRequired() {
        return false;
    }

    @Override
    public void doUpgrade() throws FishEyeUpgradeException {
        for (JiraWorkflow workflow : this.workflowManager.getWorkflows()) {
            JiraWorkflow draft;
            if (this.shouldUpgradeWorkflow(workflow)) {
                try {
                    this.workflowManager.saveWorkflowWithoutAudit(workflow);
                }
                catch (WorkflowException e) {
                    this.logError("Exception encountered when attempting to storing updated workflow " + workflow.getName(), e);
                }
            }
            if ((draft = this.workflowManager.getDraftWorkflow(workflow.getName())) == null || !this.shouldUpgradeWorkflow(draft)) continue;
            try {
                this.workflowManager.saveWorkflowWithoutAudit(draft);
            }
            catch (WorkflowException e) {
                this.logError("Exception encountered when attempting to storing updated draft workflow " + draft.getName(), e);
            }
        }
        this.properties.setBoolean(this.getUpgradeString(), true);
    }

    private boolean shouldUpgradeWorkflow(JiraWorkflow workflow) {
        boolean isSystemWorkflow;
        try {
            isSystemWorkflow = workflow.isSystemWorkflow();
        }
        catch (WorkflowException e) {
            this.logError("Could not determine whether workflow '" + workflow.getName() + "' is System Workflow, skipping. Error: ", e);
            return false;
        }
        return this.upgradeWorkflow(workflow, isSystemWorkflow);
    }

    protected abstract boolean upgradeWorkflow(JiraWorkflow var1, boolean var2);

    protected abstract String getUpgradeString();

    protected abstract Logger getLogger();

    protected void logError(String s, Throwable e) {
        this.getLogger().error(s, e);
    }

    protected void logError(String s) {
        this.getLogger().error(s);
    }

    protected void logWarn(String s) {
        this.getLogger().warn(s);
    }

    protected void logInfo(String s) {
        this.getLogger().info(s);
    }
}

