/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.util;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.util.ConfigUtil;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigUtilImpl
implements ConfigUtil {
    private static Logger log = LoggerFactory.getLogger(ConfigUtilImpl.class);
    private FishEyeProperties properties;

    public ConfigUtilImpl(FishEyeProperties properties) {
        this.properties = properties;
    }

    @Override
    public String resolveUrl(String url) {
        return url.endsWith("/") ? url : url + "/";
    }

    @Override
    public String resolveRpcUrl(String rpcUrl, String displayUrl) {
        if (rpcUrl == null) {
            if (displayUrl != null) {
                return displayUrl;
            }
        } else {
            return this.resolveUrl(rpcUrl);
        }
        return rpcUrl;
    }

    @Override
    public Charset resolveCharset(String name) {
        if (name != null) {
            if (Charset.isSupported(name)) {
                return Charset.forName(name);
            }
            log.error("Charset '" + name + "' is not supported. Using platform default.");
        }
        return null;
    }

    @Override
    public int retrieveValidatedInt(String key, int defaultValue) {
        return this.retrieveValidatedInt(key, Integer.MAX_VALUE, defaultValue);
    }

    @Override
    public int retrieveValidatedIntWithServerId(String key, int defaultValue, Integer fisheyeServerId) {
        return this.retrieveValidatedIntWithServerId(key, Integer.MAX_VALUE, defaultValue, fisheyeServerId);
    }

    @Override
    public int retrieveValidatedInt(String key, int max, int defaultValue) {
        return this.retrieveValidatedIntWithServerId(key, max, defaultValue, null);
    }

    @Override
    public int retrieveValidatedIntWithServerId(String key, int max, int defaultValue, Integer fisheyeServerId) {
        Long longValue = this.properties.getLong(key, fisheyeServerId);
        if (longValue == null) {
            return defaultValue;
        }
        if (longValue > (long)max) {
            log.error("Maximum value for property '" + key + "' is '" + max + "'. Returning + '" + max + "'");
            return max;
        }
        int intValue = longValue.intValue();
        if (intValue < 0) {
            log.error("Property '" + key + "' should not be negative. Found '" + intValue + "'");
            return defaultValue;
        }
        return intValue;
    }
}

