/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.AbstractResponseParser;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

public class RevisionParser
extends AbstractResponseParser {
    String repositoryName;
    private int maxRevisions;

    public RevisionParser(String repositoryName) {
        this.repositoryName = repositoryName;
        this.maxRevisions = Integer.MAX_VALUE;
    }

    public RevisionParser(String repositoryName, int maxRevisions) {
        this.repositoryName = repositoryName;
        this.maxRevisions = maxRevisions;
    }

    @Override
    public List parse(FishEyeDocumentHolder docHolder) throws IOException {
        Document doc = docHolder.getDoc();
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        if (doc != null) {
            List rows = doc.selectNodes("/response/row");
            int revCount = 0;
            Iterator rowIt = rows.iterator();
            while (rowIt.hasNext() && revCount++ < this.maxRevisions) {
                Date date;
                Node row = (Node)rowIt.next();
                String author = row.valueOf("author");
                String rev = row.valueOf("revision");
                String csid = row.valueOf("csid");
                String path = row.valueOf("path");
                String comment = row.valueOf("comment");
                if (comment != null) {
                    comment = comment.trim();
                }
                int totalLines = Integer.parseInt(row.valueOf("totalLines"));
                int linesAdded = Integer.parseInt(row.valueOf("linesAdded"));
                int linesRemoved = Integer.parseInt(row.valueOf("linesRemoved"));
                String state = this.bool(row.valueOf("isMoved")) ? "moved" : (this.bool(row.valueOf("isCopied")) ? "copied" : (this.bool(row.valueOf("isDeleted")) ? "deleted" : (this.bool(row.valueOf("isAdded")) ? "added" : "changed")));
                try {
                    date = FishEyeUtil.fromISO8601(row.valueOf("date"));
                }
                catch (ParseException e) {
                    throw new IOException("Failed to parse date for '" + this.repositoryName + ":" + csid + ":" + path + "': " + e, e);
                }
                Revision revision = new Revision(path, rev, author, date, state, totalLines, linesAdded, linesRemoved, csid, comment, null, this.repositoryName, docHolder.getBaseUrl(), docHolder.isCru());
                ArrayList<Review> reviews = new ArrayList<Review>();
                List reviewNodes = row.selectNodes("reviews/review");
                for (Node r : reviewNodes) {
                    reviews.add(this.extractReviewFromNode(r, docHolder.getBaseUrl()));
                }
                revision.setReviews(reviews);
                revisions.add(revision);
            }
        }
        return revisions;
    }

    private boolean bool(String s) {
        return Boolean.valueOf(s);
    }
}

