/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.eyeql;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.eyeql.WhereClause;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import java.util.Calendar;
import java.util.Date;

public class WhereClauseFactory {
    private static CurrentDateGenerator currentDate = new CurrentDateGenerator(){

        @Override
        public Calendar get() {
            return Calendar.getInstance();
        }
    };

    public static WhereClause afterDate(Date date) {
        return new WhereClause("date > " + FishEyeUtil.toEyeQLFormat(date));
    }

    public static WhereClause beforeDate(Date date) {
        return new WhereClause("date < " + FishEyeUtil.toEyeQLFormat(date));
    }

    public static WhereClause betweenDates(Date earlyBound, Date lateBound) {
        return WhereClauseFactory.betweenDates(FishEyeUtil.toEyeQLFormat(earlyBound), FishEyeUtil.toEyeQLFormat(lateBound));
    }

    public static WhereClause betweenDates(String earlyBound, String lateBound) {
        StringBuilder clause = new StringBuilder().append("date in [").append(earlyBound).append(", ").append(lateBound).append("]");
        return new WhereClause(clause.toString());
    }

    public static WhereClause withinLastNDays(int n) {
        Calendar dateLowerBound = currentDate.get();
        dateLowerBound.add(6, -n);
        return WhereClauseFactory.afterDate(dateLowerBound.getTime());
    }

    public static WhereClause issueKeyIs(String issueKey) {
        StringBuilder clause = new StringBuilder().append("comment =~ '").append(FishEyeUtil.makeIssueKeyRegex(issueKey)).append("'");
        return new WhereClause(clause.toString());
    }

    public static WhereClause issueKeyMatches(String issueKey) {
        StringBuilder clause = new StringBuilder().append("comment matches '").append(issueKey).append("'");
        return new WhereClause(clause.toString());
    }

    public static WhereClause issueKeyOrJobIdIs(String issueKey) {
        StringBuilder clause = new StringBuilder().append("(comment =~ '").append(FishEyeUtil.makeIssueKeyRegex(issueKey)).append("' or p4:jobid = '").append(issueKey).append("')");
        return new WhereClause(clause.toString());
    }

    public static WhereClause issueKeyOrJobIdMatches(String issueKey) {
        StringBuilder clause = new StringBuilder().append("(comment matches '").append(issueKey).append("' or p4:jobid =~ '").append(FishEyeUtil.makeIssueKeyRegex(issueKey)).append("')");
        return new WhereClause(clause.toString());
    }

    public static WhereClause projectKeyIs(String projectKey) {
        StringBuilder clause = new StringBuilder().append("comment =~ '").append(FishEyeUtil.makeProjectKeyRegex(projectKey)).append("'");
        return new WhereClause(clause.toString());
    }

    public static WhereClause projectKeyMatches(String projectKey) {
        StringBuilder clause = new StringBuilder().append("comment matches '").append(projectKey).append("'");
        return new WhereClause(clause.toString());
    }

    public static WhereClause projectKeyOrJobPrefixIs(String projectKey) {
        String projectKeyRegex = FishEyeUtil.makeProjectKeyRegex(projectKey);
        StringBuilder clause = new StringBuilder().append("(comment =~ '").append(projectKeyRegex).append("' or p4:jobid =~ '").append(projectKeyRegex).append("')");
        return new WhereClause(clause.toString());
    }

    public static WhereClause projectKeyOrJobPrefixMatches(String projectKey) {
        StringBuilder clause = new StringBuilder().append("(comment matches '").append(projectKey).append("' or p4:jobid =~ '").append(FishEyeUtil.makeProjectKeyRegex(projectKey)).append("')");
        return new WhereClause(clause.toString());
    }

    public static WhereClause csidIs(String csid) {
        StringBuilder clause = new StringBuilder().append("csid = '").append(csid).append("'");
        return new WhereClause(clause.toString());
    }

    protected static void setCurrentDateGenerator(CurrentDateGenerator generator) {
        currentDate = generator;
    }

    public static interface CurrentDateGenerator {
        public Calendar get();
    }
}

