/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.eyeql;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.eyeql.WhereClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class EyeQLQuery {
    public static final String GROUP_BY_CHANGESET = "changeset";
    public static final String GROUP_BY_DIR = "dir";
    public static final String GROUP_BY_FILE = "file";
    private String dir = null;
    private String groupBy = null;
    private boolean orderByDate = false;
    private int limitOffset = 0;
    private int limitDuration = -1;
    private boolean limited = false;
    private List whereClauses = new ArrayList();
    private List returnClauses = new ArrayList();

    public EyeQLQuery setOrderByDate(boolean orderByDate) {
        this.orderByDate = orderByDate;
        return this;
    }

    public EyeQLQuery setGroupBy(String groupBy) {
        this.groupBy = groupBy;
        return this;
    }

    public EyeQLQuery setDir(String dir) {
        this.dir = dir;
        return this;
    }

    public EyeQLQuery setLimit(int duration) {
        this.limited = true;
        this.limitDuration = duration;
        return this;
    }

    public EyeQLQuery setLimit(int offset, int duration) {
        this.limited = true;
        this.limitOffset = offset;
        this.limitDuration = duration;
        return this;
    }

    public EyeQLQuery addWhereClause(String clause) {
        this.whereClauses.add(this.eyeQLStringEscape(clause));
        return this;
    }

    public EyeQLQuery addWhereClause(WhereClause clause) {
        this.addWhereClause(clause.toString());
        return this;
    }

    public EyeQLQuery addReturnClause(String clause) {
        this.returnClauses.add(clause);
        return this;
    }

    public EyeQLQuery addReturnClauses(String[] clauses) {
        this.returnClauses.addAll(Arrays.asList(clauses));
        return this;
    }

    public String toString() {
        int lastIndex;
        Iterator it;
        StringBuilder buff = new StringBuilder().append("select revisions ");
        if (this.dir != null) {
            buff.append("from dir ").append(this.dir).append(" ");
        }
        if (!this.whereClauses.isEmpty()) {
            it = this.whereClauses.iterator();
            buff.append("where ").append((String)it.next()).append(" ");
            while (it.hasNext()) {
                buff.append("and ").append((String)it.next()).append(" ");
            }
        }
        if (this.orderByDate) {
            buff.append("order by date ");
        }
        if (this.groupBy != null) {
            buff.append("group by ").append(this.groupBy).append(" ");
        }
        if (!this.returnClauses.isEmpty()) {
            it = this.returnClauses.iterator();
            buff.append("return ").append((String)it.next());
            while (it.hasNext()) {
                buff.append(", ").append((String)it.next());
            }
            buff.append(" ");
        }
        if (this.limited) {
            buff.append(" limit ").append(this.limitOffset).append(",").append(this.limitDuration).append(" ");
        }
        if (buff.charAt(lastIndex = buff.length() - 1) == ' ') {
            buff.deleteCharAt(lastIndex);
        }
        return buff.toString();
    }

    protected String eyeQLStringEscape(String s) {
        return s.replaceAll("\\\\", "\\\\\\\\");
    }
}

