/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.rest;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.core.util.XMLUtils;
import com.atlassian.jirafisheyeplugin.exceptions.OAuthNotAuthorisedException;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.command.CrucibleRestCommand;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.command.RestCommand;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.ResponseParser;
import com.atlassian.jirafisheyeplugin.util.CharsetHelper;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.security.xml.libs.SecureDom4jFactory;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FishEyeRestApiManagerImpl
implements FishEyeRestApiManager {
    private static final Logger log = LoggerFactory.getLogger(FishEyeRestApiManagerImpl.class);
    private static final int MAX_REDIRECTS = 3;
    private static final Set<Integer> REDIRECT_STATUS_CODES = Sets.newHashSet((Object[])new Integer[]{301, 302, 303, 307});
    private static final String SEPARATOR = " -> ";
    private static final Object ALREADY_WARNED = new Object();
    private final Cache<URI, Object> warnedUrls = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.HOURS).build();
    private final ApplicationLinkService applicationLinkService;
    private final CharsetHelper charsetHelper;

    public FishEyeRestApiManagerImpl(ApplicationLinkService applicationLinkService, CharsetHelper charsetHelper) {
        this.applicationLinkService = applicationLinkService;
        this.charsetHelper = charsetHelper;
    }

    @Override
    public List callFisheye(FishEyeRepository rep, RestCommand restCommand, ResponseParser parser) throws IOException {
        restCommand.getParameters().put("rep", rep.getName());
        return this.callFisheye(rep.getInstance(), restCommand, parser);
    }

    @Override
    public List callFisheye(FishEyeInstance instance, RestCommand restCommand, ResponseParser parser) throws IOException {
        Document doc = this.callFisheye(instance, restCommand);
        return parser.parse(new FishEyeDocumentHolder(doc, instance.getUrl(), instance.isCru()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document callFisheye(FishEyeInstance instance, RestCommand command) throws IOException {
        ApplicationLink applicationLink = this.getApplicationLink(instance);
        if (applicationLink == null) {
            throw new IOException(String.format("The application link with id '%s' was not found for instance '%s'", instance.getApplicationId(), instance));
        }
        URI configuredUrl = command.makeAbsoluteURL(applicationLink.getRpcUrl().toString());
        ArrayDeque<String> triedURLs = new ArrayDeque<String>();
        AtomicReference<String> nextUrlToTry = new AtomicReference<String>(configuredUrl.toString());
        Document document = null;
        for (int i = 0; i < 3; ++i) {
            ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
            try {
                ApplicationLinkRequest request = this.buildRequest(instance, requestFactory, nextUrlToTry.get(), command);
                Charset charset = instance.getCharset();
                if (charset != null) {
                    String cType = command instanceof CrucibleRestCommand ? "application/xml" : "application/x-www-form-urlencoded";
                    request.addHeader("Content-Type", cType + "; charset=" + charset.name());
                }
                log.debug("About to execute command on '{}': {}", (Object)nextUrlToTry.get(), (Object)command);
                String timerKey = "callFisheye() httpClient.executeMethod()";
                try {
                    UtilTimerStack.push((String)"callFisheye() httpClient.executeMethod()");
                    document = (Document)request.execute((ApplicationLinkResponseHandler)new FishEyeResponseHandler(charset, nextUrlToTry, triedURLs));
                    if (document == null) continue;
                    break;
                }
                finally {
                    UtilTimerStack.pop((String)"callFisheye() httpClient.executeMethod()");
                }
            }
            catch (CredentialsRequiredException e) {
                throw new OAuthNotAuthorisedException("OAuth not configured", (AuthorisationURIGenerator)e);
            }
            catch (CredentialsRequiredException2 e) {
                throw new OAuthNotAuthorisedException("OAuth not configured", (AuthorisationURIGenerator)requestFactory);
            }
            catch (ResponseException e) {
                throw new IOException(String.format("Error in remote call to '%s' (%s) [%s] : %s", applicationLink.getName(), applicationLink.getRpcUrl(), command, e.getMessage()), e);
            }
        }
        this.logRedirects(applicationLink.getRpcUrl(), triedURLs);
        if (document == null) {
            throw new IOException(String.format("Error while executing command '%s'. Failed after exceeding maximum number of redirects (%d). Redirect chain: %s", command, 3, StringUtils.join(triedURLs, SEPARATOR)));
        }
        return document;
    }

    private void logRedirects(URI baseURL, Deque<String> triedURLs) {
        if (triedURLs.size() > 1) {
            Object previouslyWarned = this.warnedUrls.asMap().put(baseURL, ALREADY_WARNED);
            if (previouslyWarned != ALREADY_WARNED) {
                if (log.isWarnEnabled()) {
                    log.warn(String.format("FishEye URL '%s' has redirected to '%s'. For performance reasons, it is recommended to set your FishEye instance URL to  location that does not redirect. Redirect chain: %s", baseURL, triedURLs.peekLast(), StringUtils.join(triedURLs, SEPARATOR)));
                }
            } else if (log.isDebugEnabled()) {
                log.warn(String.format("FishEye URL '%s' has redirected to '%s'. Redirect chain: %s", baseURL, triedURLs.peekLast(), StringUtils.join(triedURLs, SEPARATOR)));
            }
        }
    }

    private void log(Response response) throws ResponseException {
        if (log.isTraceEnabled()) {
            String timerKey = "debug request.getResponseBodyAsString()";
            try {
                UtilTimerStack.push((String)timerKey);
                log.trace("Response: " + response.getResponseBodyAsString());
            }
            finally {
                UtilTimerStack.pop((String)timerKey);
            }
        }
    }

    protected ApplicationLinkRequest buildRequest(FishEyeInstance instance, ApplicationLinkRequestFactory requestFactory, String url, RestCommand restCommand) throws CredentialsRequiredException {
        ArrayList postParams = Lists.newArrayList();
        ArrayList queryParamValues = Lists.newArrayList();
        UriBuilder builder = UriBuilder.fromUri((String)url);
        if (restCommand.getMethodType() == Request.MethodType.GET) {
            int i = 0;
            for (Map.Entry<String, String> queryParam : restCommand.getParameters().entrySet()) {
                queryParamValues.add(queryParam.getValue());
                builder = builder.queryParam(queryParam.getKey(), new Object[]{String.format("{%d}", i++)});
            }
        } else if (restCommand.getMethodType() == Request.MethodType.POST) {
            for (Map.Entry<String, String> postParam : restCommand.getParameters().entrySet()) {
                postParams.add(postParam.getKey());
                postParams.add(postParam.getValue());
            }
        }
        URI requestUri = builder.build((Object[])queryParamValues.toArray(new String[queryParamValues.size()]));
        log.debug("Request URI is '{}'", (Object)requestUri);
        ApplicationLinkRequest request = requestFactory.createRequest(restCommand.getMethodType(), requestUri.toString());
        if (!postParams.isEmpty()) {
            request.addRequestParameters(postParams.toArray(new String[postParams.size()]));
        }
        int connectionTimeout = instance.getConnectionTimeout() != -1 ? instance.getConnectionTimeout() : 10000;
        log.trace("Setting connection timeout to {}", (Object)connectionTimeout);
        request.setConnectionTimeout(connectionTimeout);
        int socketTimeout = instance.getSocketTimeout() != -1 ? instance.getSocketTimeout() : 10000;
        log.trace("Setting socket timeout to {}", (Object)socketTimeout);
        request.setSoTimeout(socketTimeout);
        return request;
    }

    protected ApplicationLink getApplicationLink(FishEyeInstance instance) {
        try {
            return this.applicationLinkService.getApplicationLink(instance.getApplicationId());
        }
        catch (TypeNotInstalledException e) {
            throw new RuntimeException(String.format("The application link '%s' has an invalid type", instance.getApplicationId()), e);
        }
    }

    private static class CredentialsRequiredException2
    extends ResponseException {
        private CredentialsRequiredException2() {
        }
    }

    class FishEyeResponseHandler
    implements ApplicationLinkResponseHandler<Document> {
        private static final String CALL_FISHEYE_XML_READER_READ = "callFisheye() xmlReader.read()";
        private final Charset charset;
        private final AtomicReference<String> nextTryURL;
        private final Deque<String> alreadyTriedURLs;

        public FishEyeResponseHandler(Charset charset, AtomicReference<String> nextTryURL, Deque<String> alreadyTriedURLs) {
            this.charset = charset;
            this.nextTryURL = nextTryURL;
            this.alreadyTriedURLs = alreadyTriedURLs;
        }

        public Document credentialsRequired(Response response) throws ResponseException {
            throw new CredentialsRequiredException2();
        }

        public Document handle(Response response) throws ResponseException {
            FishEyeRestApiManagerImpl.this.log(response);
            this.alreadyTriedURLs.add(this.nextTryURL.get());
            if (!response.isSuccessful()) {
                throw new ResponseException(String.format("Received status code %d (%s)", response.getStatusCode(), response.getStatusText()));
            }
            if (REDIRECT_STATUS_CODES.contains(response.getStatusCode())) {
                String location = response.getHeader("location");
                if (location == null) {
                    throw new ResponseException(String.format("Received status code %d (%s) but no location was specified", response.getStatusCode(), response.getStatusText()));
                }
                this.nextTryURL.set(location);
                return null;
            }
            return this.extractDocumentFrom(response);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Document extractDocumentFrom(Response response) throws ResponseException {
            SAXReader xmlReader = SecureDom4jFactory.newSaxReader();
            BufferedReader responseReader = new BufferedReader(new InputStreamReader(response.getResponseBodyAsStream(), this.charset == null ? FishEyeRestApiManagerImpl.this.charsetHelper.defaultCharset() : this.charset));
            try {
                Document result;
                try {
                    UtilTimerStack.push((String)CALL_FISHEYE_XML_READER_READ);
                    result = xmlReader.read((Reader)responseReader);
                }
                finally {
                    UtilTimerStack.pop((String)CALL_FISHEYE_XML_READER_READ);
                }
                if ("error".equals(result.getRootElement().getName())) {
                    throw new ResponseException(result.getRootElement().getText());
                }
                Document document = result;
                return document;
            }
            catch (DocumentException e) {
                throw new ResponseException(String.format("Failed to parse FishEye response: %s", XMLUtils.escape((String)e.getMessage())), (Throwable)e);
            }
            finally {
                try {
                    ((Reader)responseReader).close();
                }
                catch (IOException e) {
                    log.warn("Error closing reader: " + responseReader, (Throwable)e);
                }
            }
        }
    }
}

