/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye;

import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.security.xml.libs.SecureDom4jFactory;
import java.io.InputStream;
import org.dom4j.Document;
import org.dom4j.io.SAXReader;

public final class ServerInfo {
    private boolean isCrucible;
    private boolean isCrucibleStandalone;

    public static ServerInfo fisheyeAndCrucible() {
        return new ServerInfo(true, false);
    }

    public static ServerInfo crucibleStandalone() {
        return new ServerInfo(false, true);
    }

    public static ServerInfo fromXML(InputStream serverResponse) throws ResponseException {
        try {
            SAXReader xmlReader = SecureDom4jFactory.newSaxReader();
            Document document = xmlReader.read(serverResponse);
            return new ServerInfo(document);
        }
        catch (Exception e) {
            throw new ResponseException(String.format("Error parsing response [%s]", serverResponse), (Throwable)e);
        }
    }

    public static ServerInfo fromDocument(Document document) {
        return new ServerInfo(document);
    }

    private ServerInfo(boolean isCrucible, boolean isCrucibleStandalone) {
        this.isCrucible = isCrucible;
        this.isCrucibleStandalone = isCrucibleStandalone;
    }

    private ServerInfo(Document document) {
        this.setProperties(document);
    }

    public boolean isCrucible() {
        return this.isCrucible;
    }

    public boolean isCrucibleStandalone() {
        return this.isCrucibleStandalone;
    }

    public String toString() {
        return "ServerInfo{isCrucible=" + this.isCrucible + ", isCrucibleStandalone=" + this.isCrucibleStandalone + '}';
    }

    private void setProperties(Document document) {
        String crucible = document.selectSingleNode("/serverInfo/isCrucible").getStringValue();
        this.isCrucible = Boolean.parseBoolean(crucible);
    }
}

