/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.AbstractFishEyeRemoteObject;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Revision
extends AbstractFishEyeRemoteObject {
    private static Logger log = LoggerFactory.getLogger(Revision.class);
    public static final String STATE_ADDED = "added";
    public static final String STATE_CHANGED = "changed";
    public static final String STATE_DELETED = "deleted";
    public static final String STATE_MOVED = "moved";
    public static final String STATE_COPIED = "copied";
    private String path;
    private String rev;
    private String author;
    private Date date;
    private String state;
    private int totalLines;
    private int linesAdded;
    private int linesRemoved;
    private String csid;
    private String msg;
    private String ancestor;
    private String rep;
    private List reviews;

    public static Revision fromDom(Node node, String url, boolean isCru) {
        Revision r = new Revision(url, isCru);
        r.path = node.valueOf("@path");
        r.rev = node.valueOf("@rev");
        r.author = node.valueOf("@author");
        r.state = node.valueOf("@state");
        r.csid = node.valueOf("@csid");
        r.ancestor = node.valueOf("@ancestor");
        r.msg = node.valueOf("log").trim();
        try {
            r.date = FishEyeUtil.fromISO8601(node.valueOf("@date"));
        }
        catch (ParseException e) {
            log.error("Error parsing date " + node.valueOf("@date"));
            e.printStackTrace();
        }
        try {
            r.totalLines = Integer.parseInt(node.valueOf("@totalLines"));
            r.linesAdded = Integer.parseInt(node.valueOf("@linesAdded"));
            r.linesRemoved = Integer.parseInt(node.valueOf("@linesRemoved"));
        }
        catch (NumberFormatException e) {
            log.error("Error parsing integers " + node.valueOf("@totalLines") + " or " + node.valueOf("@linesAdded") + " or " + node.valueOf("@linesRemoved"));
            e.printStackTrace();
        }
        log.debug("Got revision: path:" + r.path + ", rev:" + r.rev);
        return r;
    }

    protected Revision(String url, boolean isCru) {
        super(url, isCru);
    }

    public Revision(String path, String rev, String author, Date date, String state, int totalLines, int linesAdded, int linesRemoved, String csid, String msg, String ancestor, String rep, String url, boolean isCru) {
        super(url, isCru);
        this.path = path;
        this.rev = rev;
        this.author = author;
        this.date = date;
        this.state = state;
        this.totalLines = totalLines;
        this.linesAdded = linesAdded;
        this.linesRemoved = linesRemoved;
        this.csid = csid;
        this.msg = msg;
        this.ancestor = ancestor;
        this.rep = rep;
    }

    public String getPath() {
        return this.path;
    }

    public String getAncestor() {
        return this.ancestor;
    }

    public void setAncestor(String ancestor) {
        this.ancestor = ancestor;
    }

    public String getRev() {
        return this.rev;
    }

    public boolean isAdded() {
        return STATE_ADDED.equals(this.state);
    }

    public boolean isChanged() {
        return STATE_CHANGED.equals(this.state);
    }

    public boolean isDeleted() {
        return STATE_DELETED.equals(this.state);
    }

    public boolean isCopied() {
        return STATE_COPIED.equals(this.state);
    }

    public boolean isMoved() {
        return STATE_MOVED.equals(this.state);
    }

    public String getAuthor() {
        return this.author;
    }

    public Date getDate() {
        return this.date;
    }

    public String getState() {
        return this.state;
    }

    public int getTotalLines() {
        return this.totalLines;
    }

    public int getLinesAdded() {
        return this.linesAdded;
    }

    public int getLinesRemoved() {
        return this.linesRemoved;
    }

    public String getCsid() {
        return this.csid;
    }

    public String getMsg() {
        return this.msg;
    }

    public String getPathWithTruncatedBranch(String branch) {
        if (branch.startsWith("/")) {
            branch = branch.substring(1);
        }
        if (this.path.startsWith(branch)) {
            return "./" + this.path.substring(branch.length());
        }
        return this.path;
    }

    public List getReviews() {
        return this.reviews;
    }

    public void setReviews(List reviews) {
        this.reviews = reviews;
    }

    public String getRep() {
        return this.rep;
    }
}

