/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;

public class RepositoryErrorReport {
    private String url;
    private String repositoryName;
    private String errorMessage;
    private String name;

    public RepositoryErrorReport(FishEyeRepository repository, String errorMessage) {
        this.name = repository.getInstance().getName();
        this.url = repository.getInstance().getUrl();
        this.repositoryName = repository.getName();
        this.errorMessage = errorMessage;
        this.sanitiseErrors();
    }

    public RepositoryErrorReport(FishEyeInstance instance, String errorMessage) {
        this.name = instance.getName();
        this.url = instance.getUrl();
        this.repositoryName = null;
        this.errorMessage = errorMessage;
        this.sanitiseErrors();
    }

    private void sanitiseErrors() {
        if (this.errorMessage == null) {
            this.errorMessage = "";
        } else if (this.errorMessage.toLowerCase().contains("permission denied")) {
            this.repositoryName = "[name hidden]";
            this.errorMessage = "PERMISSION DENIED";
        }
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String toString() {
        return this.repositoryName + ":" + this.url + ":" + this.errorMessage;
    }
}

