/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye;

import com.atlassian.jira.cluster.ClusterSafe;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.util.JiraKeyUtils;
import com.atlassian.jirafisheyeplugin.config.RefreshManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.crucible.CrucibleProject;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.RepositoryPath;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.FishEyeRestApiManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.command.RestCommandFactory;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.eyeql.EyeQLQuery;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.eyeql.WhereClauseFactory;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.MultipleStringParser;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.ProjectParser;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.ResponseParser;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.response.RevisionParser;
import com.atlassian.util.profiling.UtilTimerStack;
import com.google.common.base.Function;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeManagerImpl
implements FishEyeManager {
    private static final Logger log = LoggerFactory.getLogger(FishEyeManagerImpl.class);
    private static final long THRESHOLD = Long.valueOf(System.getProperty("jirafisheye.crucible.projects.list.refresh.frequency", Long.toString(60000L)));
    private PermissionManager permissionManager;
    private IssueManager issueManager;
    private FishEyeRestApiManager apiManager;
    private FishEyeInstanceStore instanceStore;
    private FishEyeRepositoryStore repositoryStore;
    private RepositoryPathStore repositoryPathStore;
    private CrucibleProjectStore crucibleProjectStore;
    private RefreshManager refreshManager;
    protected FishEyeConfig config;
    private Map<FishEyeInstance, List> crucibleProjects = new HashMap<FishEyeInstance, List>();
    @ClusterSafe(value="Locally managed cache")
    private Cache<FishEyeInstance, Long> lastChecked = CacheBuilder.newBuilder().expireAfterWrite(THRESHOLD, TimeUnit.MILLISECONDS).build();

    protected FishEyeManagerImpl() {
    }

    public FishEyeManagerImpl(PermissionManager permissionManager, IssueManager issueManager, FishEyeRestApiManager apiManager, FishEyeInstanceStore instanceStore, FishEyeRepositoryStore repositoryStore, FishEyeConfig config, RepositoryPathStore repositoryPathStore, CrucibleProjectStore crucibleProjectStore, RefreshManager refreshManager) {
        this.permissionManager = permissionManager;
        this.issueManager = issueManager;
        this.apiManager = apiManager;
        this.instanceStore = instanceStore;
        this.repositoryStore = repositoryStore;
        this.config = config;
        this.repositoryPathStore = repositoryPathStore;
        this.crucibleProjectStore = crucibleProjectStore;
        this.refreshManager = refreshManager;
    }

    protected void refreshCrucibleProjects() {
        HashMap<String, String> cruProjectKey2baseUrlMap = new HashMap<String, String>();
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            if (!instance.isCru()) continue;
            try {
                ArrayList retrieved = Lists.newArrayList((Iterable)Lists.transform(this.getProjectsImpl(instance), (Function)new Function<CrucibleProject, String>(){

                    public String apply(CrucibleProject from) {
                        return from.getKey();
                    }
                }));
                Collection<String> existing = this.crucibleProjectStore.getCrucibleProjectKeys(instance.getId());
                retrieved.removeAll(existing);
                if (retrieved.isEmpty()) continue;
                HashSet<String> merged = new HashSet<String>();
                merged.addAll(retrieved);
                merged.addAll(existing);
                this.crucibleProjectStore.setCrucibleProjectKeys(merged, instance.getId());
                for (String cruProjectKey : merged) {
                    cruProjectKey2baseUrlMap.put(cruProjectKey, instance.getUrl());
                }
            }
            catch (IOException e) {
                log.error("Error encountered resolving Crucible projects for " + instance.getUrl(), (Throwable)e);
            }
        }
        this.config.setCrucibleProjectToUrlMappings(cruProjectKey2baseUrlMap);
    }

    @Override
    public void refreshConfig() {
    }

    @Override
    public Collection getRepositories(Integer fisheyeInstanceId) throws IOException {
        return this.getRepositories(this.instanceStore.getFishEyeInstance(fisheyeInstanceId));
    }

    public Collection getRepositories(FishEyeInstance fisheyeInstance) throws IOException {
        List reps = this.apiManager.callFisheye(fisheyeInstance, RestCommandFactory.repositories(), (ResponseParser)MultipleStringParser.PARSER);
        if (reps.isEmpty()) {
            log.warn("Found no repositories in FishEye instance at '" + fisheyeInstance.getUrl() + "'");
        }
        return reps;
    }

    @Override
    public Collection getRepositoriesForProject(String projectKey) {
        Collection<FishEyeRepository> repos = this.repositoryStore.getRepositories(projectKey);
        RepositoryPath path = this.repositoryPathStore.getRepositoryPath(projectKey);
        if (path != null) {
            repos.add(path.getRep());
        }
        return repos;
    }

    @Override
    public Collection getInstancesForProject(String projectKey) {
        HashSet<FishEyeInstance> instances = new HashSet<FishEyeInstance>();
        Collection reps = this.getRepositoriesForProject(projectKey);
        for (FishEyeRepository repository : reps) {
            instances.add(repository.getInstance());
        }
        instances.addAll(this.getCrucibleStandaloneInstances());
        return instances;
    }

    @Override
    public Collection getCrucibleStandaloneInstances() {
        return this.instanceStore.getCrucibleStandaloneInstances();
    }

    @Override
    public boolean existsCrucibleStandaloneInstances() {
        return !this.getCrucibleStandaloneInstances().isEmpty();
    }

    protected Collection getIssueKeysFromString(String string) {
        return JiraKeyUtils.getIssueKeysFromString((String)string);
    }

    @Override
    public boolean hasValidConfig() {
        return this.config != null && this.config.isValid();
    }

    @Override
    public List getRevisionsForProject(final Project project, final int lastNDays) throws IOException {
        if (!this.config.isValid()) {
            throw new IllegalStateException("The Fisheye plugin is currently unavailable due to a configuration error");
        }
        ArrayList revisions = new ArrayList();
        Collection projectRepos = this.getRepositoriesForProject(project.getKey());
        for (FishEyeRepository rep : projectRepos) {
            Query q = new Query(){

                @Override
                public Object doQuery(FishEyeRepository rep, boolean searchJobId) throws IOException {
                    EyeQLQuery query = new EyeQLQuery();
                    if (searchJobId) {
                        query.addWhereClause(WhereClauseFactory.projectKeyOrJobPrefixMatches(project.getKey()));
                    } else {
                        query.addWhereClause(WhereClauseFactory.projectKeyMatches(project.getKey()));
                    }
                    query.addWhereClause(WhereClauseFactory.withinLastNDays(lastNDays));
                    query.addReturnClauses(new String[]{"path", "revision", "author", "date", "comment", "csid", "reviews", "totalLines", "linesAdded", "linesRemoved"});
                    return FishEyeManagerImpl.this.apiManager.callFisheye(rep, RestCommandFactory.query(query), (ResponseParser)new RevisionParser(rep.getName()));
                }
            };
            revisions.addAll((Collection)this.doQuery(q, rep));
        }
        return revisions;
    }

    @Override
    public List groupRevisionsIntoChangesets(List revisions) {
        HashMap<String, Changeset> changesets = new HashMap<String, Changeset>();
        for (Revision r : revisions) {
            String csKey = r.getRep() + ":" + r.getCsid();
            Changeset cs = (Changeset)changesets.get(csKey);
            if (cs == null) {
                cs = new Changeset(r.getRep(), r.getCsid(), r.getAuthor(), r.getDate(), r.getMsg(), new ArrayList(), r.getBaseUrl(), r.isCru());
                changesets.put(csKey, cs);
            }
            cs.addRevision(r);
        }
        return new ArrayList(changesets.values());
    }

    private void updateInstanceRepositories() {
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            if (instance.isCruStandalone()) continue;
            try {
                Collection retrieved = this.getRepositories(instance);
                Collection stored = Collections2.transform(this.repositoryStore.getRepositoriesForInstance(instance.getId()), (Function)new Function<FishEyeRepository, String>(){

                    public String apply(FishEyeRepository from) {
                        return from.getName();
                    }
                });
                retrieved.removeAll(stored);
                if (retrieved.isEmpty()) continue;
                log.debug("Found new repository(s) for '" + instance.getUrl() + "': " + retrieved);
                this.repositoryStore.addRepositories(retrieved, instance.getId());
            }
            catch (IOException e) {
                log.error("Error retrieving repositories for '" + instance.getUrl() + "'", (Throwable)e);
            }
        }
    }

    private Object doQuery(Query query, FishEyeRepository rep) throws IOException {
        try {
            return query.doQuery(rep, true);
        }
        catch (IOException e) {
            return query.doQuery(rep, false);
        }
    }

    @Override
    public boolean isCrucibleEnabled() {
        return this.config.isCrucibleEnabled();
    }

    @Override
    public boolean isCrucibleEnabled(Project context) {
        Collection instances = this.getInstancesForProject(context.getKey());
        for (FishEyeInstance instance : instances) {
            if (!instance.isCru()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAssociatedWithFishEye(String projectKey) {
        return !this.repositoryStore.getRepositories(projectKey).isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAssociatedWithCrucible(String projectKey) {
        String timerKey = "FisheyeManagerImpl.isAssociatedWithCrucible()";
        try {
            UtilTimerStack.push((String)"FisheyeManagerImpl.isAssociatedWithCrucible()");
            for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
                if (this.crucibleProjectStore.getDefaultCrucibleProjectKey(projectKey, instance.getId()) != null) {
                    boolean bl = true;
                    return bl;
                }
                Collection<String> crucibleProjectKeys = this.crucibleProjectStore.getCrucibleProjectKeys(instance.getId());
                if (crucibleProjectKeys.isEmpty()) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            UtilTimerStack.pop((String)"FisheyeManagerImpl.isAssociatedWithCrucible()");
        }
    }

    @Override
    public List getProjects(Integer fisheyeInstanceId) throws IOException {
        return this.getProjects(this.instanceStore.getFishEyeInstance(fisheyeInstanceId));
    }

    @Override
    public List<CrucibleProject> getProjects(FishEyeInstance instance) throws IOException {
        boolean notInCache = !this.crucibleProjects.containsKey(instance);
        boolean cachExpired = this.isCachExpired(instance, false);
        if (notInCache || cachExpired) {
            log.debug(String.format("crucible project list cache miss on instance [%s] : !crucibleProjects.containsKey(instance)=[%s] isCachExpired(instance)=[%s]", instance, notInCache, cachExpired));
            this.crucibleProjects.put(instance, this.getProjectsImpl(instance));
            this.isCachExpired(instance, true);
            return this.crucibleProjects.get(instance);
        }
        log.debug(String.format("crucible project list cache hit on instance [%s] : !crucibleProjects.containsKey(instance)=[%s] isCachExpired(instance)=[%s]", instance, notInCache, cachExpired));
        return this.crucibleProjects.get(instance);
    }

    private boolean isCachExpired(FishEyeInstance instance, boolean updateTime) {
        Long lastCheck = (Long)this.lastChecked.getIfPresent((Object)instance);
        long t = System.currentTimeMillis();
        if (lastCheck == null || t - lastCheck > THRESHOLD) {
            if (updateTime) {
                this.lastChecked.put((Object)instance, (Object)t);
            }
            return true;
        }
        return false;
    }

    private List<CrucibleProject> getProjectsImpl(FishEyeInstance instance) throws IOException {
        if (instance.isCru()) {
            return this.apiManager.callFisheye(instance, RestCommandFactory.projects(), (ResponseParser)ProjectParser.PARSER);
        }
        return Collections.emptyList();
    }

    @Override
    public boolean isMappedProject(String projectKey) {
        boolean isMapped = true;
        for (FishEyeInstance instance : this.instanceStore.getAllFishEyeInstances()) {
            isMapped = isMapped && this.isMappedProject(projectKey, instance);
        }
        return isMapped;
    }

    private boolean isMappedProject(String projectKey, FishEyeInstance instance) {
        boolean isMapped = false;
        for (String cruProjectKey : this.crucibleProjectStore.getCrucibleProjectKeys(instance.getId())) {
            if (!this.crucibleProjectStore.getMappedCrucibleProjectKeys(cruProjectKey, instance.getId()).contains(projectKey)) continue;
            isMapped = true;
        }
        return isMapped;
    }

    @Override
    public boolean isMappedRepository(String projectKey) {
        return this.repositoryStore.isMapped(projectKey) || this.repositoryPathStore.hasRepositoryPath(projectKey);
    }

    @Override
    public FishEyeConfig getConfig() {
        return this.config;
    }

    @Override
    public String resolveFishEyeBaseUrl(Collection reps) {
        String defaultUrl = this.instanceStore.getDefaultFishEyeInstance().getUrl();
        if (reps.isEmpty()) {
            return defaultUrl;
        }
        String url = null;
        for (FishEyeRepository rep : reps) {
            if (url != null && !url.equals(rep.getInstance().getUrl())) {
                url = defaultUrl;
                break;
            }
            url = rep.getInstance().getUrl();
        }
        return url;
    }

    private static interface Query {
        public Object doQuery(FishEyeRepository var1, boolean var2) throws IOException;
    }
}

