/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.crucible;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.AbstractFishEyeRemoteObject;
import com.opensymphony.util.TextUtils;

public class ReviewImpl
extends AbstractFishEyeRemoteObject
implements Review {
    private static final int DESC_PREVIEW_LENGTH = 200;
    private static final String DESC_PREVIEW_NEWLINE_REPLACEMENT = " ";
    private static final String DESC_PREVIEW_ELLIPSIS = "...";
    private String id;
    private String title;
    private String description;
    private String state;
    private int metaState;

    public ReviewImpl(String id, String title, String description, String state, int metaState, String baseUrl) {
        super(baseUrl, true);
        this.id = id;
        this.title = title;
        this.description = description;
        this.state = state;
        this.metaState = metaState;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getCruProjectKey() {
        return this.id.substring(0, this.id.indexOf("-"));
    }

    @Override
    public String getTitle() {
        return this.title;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getDescriptionPreview() {
        if (this.description == null) {
            return "";
        }
        if (this.description.length() <= 200) {
            return this.description.replaceAll("\r?\n", DESC_PREVIEW_NEWLINE_REPLACEMENT);
        }
        return this.description.substring(0, 200).replaceAll("\r?\n", DESC_PREVIEW_NEWLINE_REPLACEMENT) + DESC_PREVIEW_ELLIPSIS;
    }

    @Override
    public String getState() {
        return this.state;
    }

    @Override
    public int getMetaState() {
        return this.metaState;
    }

    @Override
    public boolean isDraft() {
        return this.metaState == 0;
    }

    @Override
    public boolean isOpen() {
        return this.metaState == 1;
    }

    @Override
    public boolean isClosed() {
        return this.metaState == 2;
    }

    @Override
    public boolean isValid() {
        return TextUtils.stringSet((String)this.id) && TextUtils.stringSet((String)this.title) && TextUtils.stringSet((String)this.state);
    }

    public String toString() {
        return this.id + ":" + this.title + ":" + this.state;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReviewImpl review = (ReviewImpl)o;
        if (this.id != null ? !this.id.equals(review.id) : review.id != null) {
            return false;
        }
        return !(this.baseUrl != null ? !this.baseUrl.equals(review.baseUrl) : review.baseUrl != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 31 * result + (this.baseUrl != null ? this.baseUrl.hashCode() : 0);
        result = 31 * result + (this.title != null ? this.title.hashCode() : 0);
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        result = 31 * result + (this.state != null ? this.state.hashCode() : 0);
        result = 31 * result + this.metaState;
        return result;
    }
}

