/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual.ApplicationLinkIdMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationLinkIdMapperImpl
implements ApplicationLinkIdMapper {
    private static final Logger log = LoggerFactory.getLogger(ApplicationLinkIdMapperImpl.class);
    private final FishEyeProperties fishEyeProperties;

    public ApplicationLinkIdMapperImpl(FishEyeProperties fishEyeProperties) {
        this.fishEyeProperties = fishEyeProperties;
    }

    @Override
    public ApplicationId fromInstanceId(Integer instanceId) {
        String applicationId = this.fishEyeProperties.getText("fisheye.applicationlink.id", instanceId == null ? 0 : instanceId);
        return applicationId != null ? new ApplicationId(applicationId) : null;
    }

    @Override
    public Integer fromApplicationId(ApplicationId applicationId) {
        String applinkIdStr = this.fishEyeProperties.getText(this.getApplinksIdKey(applicationId));
        if (applinkIdStr != null) {
            return Integer.valueOf(applinkIdStr, 10);
        }
        return null;
    }

    @Override
    public void associate(Integer instanceId, ApplicationId applicationId) {
        this.fishEyeProperties.setText("fisheye.applicationlink.id", applicationId.get(), instanceId);
        this.fishEyeProperties.setText(this.getApplinksIdKey(applicationId), Integer.toString(instanceId, 10));
        log.debug("Associated FishEye instance id [{}] to application link id [{}]", (Object)instanceId, (Object)applicationId.get());
    }

    @Override
    public void dissociate(Integer instanceId, ApplicationId applicationId) {
        this.fishEyeProperties.removeProperty("fisheye.applicationlink.id", instanceId);
        this.fishEyeProperties.removeProperty(this.getApplinksIdKey(applicationId));
        log.debug("Dissociated FishEye instance id [{}] from application link id [{}]", (Object)instanceId, (Object)applicationId);
    }

    private String getApplinksIdKey(ApplicationId applicationId) {
        return "ual.%APPLINKSID%.instance.id".replace("%APPLINKSID%", applicationId.get());
    }
}

