/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.RepositoryPathStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.RepositoryPath;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryPathStoreImpl
implements RepositoryPathStore,
FishEyePropertyKeys {
    private static Logger log = LoggerFactory.getLogger(RepositoryPathStoreImpl.class);
    private final FishEyeProperties properties;
    private final FishEyeRepositoryStore repositoryStore;
    private final Map<Project, RepositoryPath> projectRepositoryPaths = new HashMap<Project, RepositoryPath>();
    private final ProjectManager projectManager;

    public RepositoryPathStoreImpl(FishEyeRepositoryStore repositoryStore, FishEyeProperties properties, ProjectManager projectManager) {
        this.projectManager = projectManager;
        this.properties = properties;
        this.repositoryStore = repositoryStore;
    }

    private Project getProject(String jiraProjectKey) {
        return this.projectManager.getProjectObjByKey(jiraProjectKey);
    }

    @Override
    public boolean hasRepositoryPath(String projectKey) {
        Project project = this.getProject(projectKey);
        return this.projectRepositoryPaths.containsKey(project);
    }

    @Override
    public RepositoryPath getRepositoryPath(String projectKey) {
        Project project = this.getProject(projectKey);
        return this.projectRepositoryPaths.get(project);
    }

    @Override
    public void updateRepositoryPath(String projectKey, RepositoryPath repPath) {
        Collection<String> projectsWithPaths = this.properties.parseCollection(this.properties.getText("fisheye.projects.with.repository.paths"));
        if (!projectsWithPaths.contains(projectKey)) {
            projectsWithPaths.add(projectKey);
            this.setProjectsWithPaths(projectsWithPaths);
        }
        this.properties.setString("fisheye." + projectKey + ".repository.instance", repPath.getRep().getInstance().getId().toString());
        this.properties.setString("fisheye." + projectKey + ".repository", repPath.getRep().getName());
        this.properties.setText("fisheye." + projectKey + ".repository.path", repPath.getPath());
    }

    @Override
    public Map<String, RepositoryPath> getRepositoryPaths() {
        HashMap<String, RepositoryPath> repositoryPaths = new HashMap<String, RepositoryPath>();
        for (Map.Entry<Project, RepositoryPath> entry : this.projectRepositoryPaths.entrySet()) {
            repositoryPaths.put(entry.getKey().getKey(), entry.getValue());
        }
        return repositoryPaths;
    }

    @Override
    public void removeRepositoryPath(String projectKey) {
        Collection<String> projectsWithPaths = this.properties.parseCollection(this.properties.getText("fisheye.projects.with.repository.paths"));
        projectsWithPaths.remove(projectKey);
        this.setProjectsWithPaths(projectsWithPaths);
        this.properties.removeProperty("fisheye." + projectKey + ".repository.instance");
        this.properties.removeProperty("fisheye." + projectKey + ".repository");
        this.properties.removeProperty("fisheye." + projectKey + ".repository.path");
    }

    protected void setProjectsWithPaths(Collection projectsWithPaths) {
        StringBuilder buff = new StringBuilder();
        Iterator iterator = projectsWithPaths.iterator();
        while (iterator.hasNext()) {
            String pKey = (String)iterator.next();
            buff.append(pKey);
            if (!iterator.hasNext()) continue;
            buff.append(", ");
        }
        this.properties.setText("fisheye.projects.with.repository.paths", buff.toString());
    }

    @Override
    public void reloadRepositoryPaths() {
        this.projectRepositoryPaths.clear();
        Collection<String> projectsWithPaths = this.properties.parseCollection(this.properties.getText("fisheye.projects.with.repository.paths"));
        for (String projectKey : projectsWithPaths) {
            Integer instanceId;
            String instance = this.properties.getString("fisheye." + projectKey + ".repository.instance");
            String repository = this.properties.getString("fisheye." + projectKey + ".repository");
            String path = this.properties.getText("fisheye." + projectKey + ".repository.path");
            if (instance == null || repository == null || path == null) {
                log.error("Error resolving repository path for " + projectKey + ": instance=" + instance + " repository=" + repository + " path=" + path);
                continue;
            }
            try {
                instanceId = new Integer(instance);
            }
            catch (NumberFormatException e) {
                log.error("Can't parse instanceId for project " + projectKey + " repository path", (Throwable)e);
                continue;
            }
            FishEyeRepository rep = this.repositoryStore.getRepository(repository, instanceId);
            if (rep == null) {
                log.error("Cannot find configured repository for " + projectKey + ": instance=" + instance + " repository=" + repository + " path=" + path);
                continue;
            }
            this.projectRepositoryPaths.put(this.getProject(projectKey), new RepositoryPath(rep, path));
        }
    }

    public void refresh() {
        this.reloadRepositoryPaths();
    }

    public int order() {
        return 40;
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.reloadRepositoryPaths();
    }
}

