/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye;

import com.atlassian.event.api.EventListener;
import com.atlassian.jira.event.ClearCacheEvent;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepositoryImpl;
import com.atlassian.jirafisheyeplugin.util.Util;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeRepositoryStoreImpl
implements FishEyeRepositoryStore,
FishEyePropertyKeys {
    private static final Logger log = LoggerFactory.getLogger(FishEyeRepositoryStoreImpl.class);
    private final Collection<FishEyeRepository> repositories = new HashSet<FishEyeRepository>();
    private final FishEyeProperties properties;
    private final FishEyeInstanceStore instanceStore;
    private final JiraAuthenticationContext authenticationContext;
    private final Map<Long, Collection<FishEyeRepository>> projectRepositories = new HashMap<Long, Collection<FishEyeRepository>>();
    private final ProjectManager projectManager;

    public FishEyeRepositoryStoreImpl(FishEyeProperties properties, FishEyeInstanceStore instanceStore, JiraAuthenticationContext authenticationContext, ProjectManager projectManager) {
        this.authenticationContext = authenticationContext;
        this.instanceStore = instanceStore;
        this.projectManager = projectManager;
        this.properties = properties;
    }

    @Override
    public FishEyeRepository getRepository(String repositoryName, String projectKey) {
        return this.getRepository(repositoryName);
    }

    @Override
    public FishEyeRepository getRepository(String repositoryName) {
        for (FishEyeRepository repository : this.repositories) {
            if (!repository.getName().equals(repositoryName)) continue;
            return repository;
        }
        return null;
    }

    @Override
    public FishEyeRepository getRepository(String repositoryName, Integer fishEyeInstanceId) {
        for (FishEyeRepository repository : this.getRepositoriesForInstance(fishEyeInstanceId)) {
            if (!repository.getName().equals(repositoryName)) continue;
            return repository;
        }
        return null;
    }

    @Override
    public boolean isMapped(String projectKey) {
        Collection<FishEyeRepository> reps = this.getFishEyeRepositories(projectKey);
        return reps != null && !reps.isEmpty();
    }

    @Override
    public Collection<FishEyeRepository> getRepositories(String projectKey) {
        Collection<FishEyeRepository> applicableRepositories = this.getFishEyeRepositories(projectKey);
        if (applicableRepositories == null) {
            applicableRepositories = this.repositories;
        }
        return new HashSet<FishEyeRepository>(applicableRepositories);
    }

    private Collection<FishEyeRepository> getFishEyeRepositories(String projectKey) {
        Long projectId = this.getProjectId(projectKey);
        return this.projectRepositories.get(projectId);
    }

    @Override
    public Collection<FishEyeRepository> getRepositories() {
        return this.repositories;
    }

    @Override
    public Collection<FishEyeRepository> getDefaultRepositories() {
        return this.getRepositoriesForInstance(this.instanceStore.getDefaultInstanceId());
    }

    @Override
    public Collection<FishEyeRepository> getRepositoriesForInstance(Integer fisheyeInstanceId) {
        return this.deserialiseRepositories(fisheyeInstanceId);
    }

    @Override
    public void setRepositories(Collection<FishEyeRepository> reps) {
        this.setRepositoriesForInstance(reps, null);
    }

    @Override
    public void setRepositoriesForInstance(Collection<FishEyeRepository> reps, Integer fisheyeInstanceId) {
        if (fisheyeInstanceId == null) {
            this.serialiseRepositories(reps);
        } else {
            this.serialiseRepositories(reps, fisheyeInstanceId);
        }
        this.setRepoLastUpdatedTime();
    }

    protected void setRepoLastUpdatedTime() {
        this.properties.setString("fisheye.repository.last.updated", Util.formatDate("EEE, d MMM yyyy HH:mm:ss Z", new Date(), this.authenticationContext.getLocale()));
    }

    protected Collection deserialiseRepositories() {
        return this.deserialiseRepositories(null);
    }

    protected Collection<FishEyeRepository> deserialiseRepositories(Integer fisheyeInstanceId) {
        Collection<String> repositoryNames = this.properties.parseCollection(this.properties.getText("fisheye.repository.list", fisheyeInstanceId));
        HashSet<FishEyeRepository> repositories = new HashSet<FishEyeRepository>();
        FishEyeInstance instance = this.instanceStore.getFishEyeInstance(fisheyeInstanceId);
        if (instance == null) {
            log.error("Could not retrieve deserialise repositories for unconfigured FishEye instance (id=" + fisheyeInstanceId + ")");
            return repositories;
        }
        Iterator<String> iterator = repositoryNames.iterator();
        while (iterator.hasNext()) {
            String repositoryName;
            String rep = repositoryName = iterator.next();
            String projects = this.properties.getText("fisheye.rep." + rep + ".projects", fisheyeInstanceId);
            Collection<String> repProjectMappings = this.properties.parseCollection(projects);
            repositories.add(new FishEyeRepositoryImpl(instance, rep, repProjectMappings));
        }
        return repositories;
    }

    protected void serialiseRepositories(Collection<FishEyeRepository> repositories) {
        this.serialiseRepositories(repositories, null);
    }

    protected void serialiseRepositories(Collection<FishEyeRepository> repositories, Integer fisheyeInstanceId) {
        if (repositories == null) {
            return;
        }
        for (FishEyeRepository oldRep : this.getRepositories()) {
            String oldRepName = oldRep.getName();
            this.properties.removeProperty("fisheye." + oldRepName + ".charset", fisheyeInstanceId);
            this.properties.removeProperty("fisheye.rep." + oldRepName + ".projects", fisheyeInstanceId);
        }
        this.properties.removeProperty("fisheye.repository.list", fisheyeInstanceId);
        StringBuilder repositoryList = new StringBuilder();
        Iterator<FishEyeRepository> iterator = repositories.iterator();
        while (iterator.hasNext()) {
            FishEyeRepository rep = iterator.next();
            repositoryList.append(rep.getName());
            if (iterator.hasNext()) {
                repositoryList.append(", ");
            }
            StringBuilder projects = new StringBuilder();
            Collection<String> mappedProjects = rep.getMappedProjectKeys();
            if (mappedProjects == null) continue;
            Iterator<String> projectIterator = mappedProjects.iterator();
            while (projectIterator.hasNext()) {
                String projectKey = projectIterator.next();
                projects.append(projectKey);
                if (!projectIterator.hasNext()) continue;
                projects.append(", ");
            }
            if (projects.length() <= 0) continue;
            String mappedProjectsKey = "fisheye.rep." + rep.getName() + ".projects";
            this.properties.setText(mappedProjectsKey, projects.toString(), fisheyeInstanceId);
        }
        if (repositoryList.length() > 0) {
            this.properties.setText("fisheye.repository.list", repositoryList.toString(), fisheyeInstanceId);
        }
    }

    @Override
    public void reloadRepositories() {
        this.repositories.clear();
        for (FishEyeInstance fe : this.instanceStore.getAllFishEyeInstances()) {
            if (fe.isCruStandalone()) continue;
            this.repositories.addAll(this.deserialiseRepositories(fe.getId()));
        }
        this.projectRepositories.clear();
        for (FishEyeRepository rep : this.repositories) {
            for (String projectKey : rep.getMappedProjectKeys()) {
                Long projectId = this.getProjectId(projectKey);
                Collection<FishEyeRepository> projectReps = this.projectRepositories.get(projectId);
                if (projectReps == null) {
                    projectReps = new HashSet<FishEyeRepository>();
                }
                projectReps.add(rep);
                this.projectRepositories.put(projectId, projectReps);
            }
        }
    }

    private Long getProjectId(String projectKey) {
        return this.projectManager.getProjectObjByKey(projectKey).getId();
    }

    @Override
    public void deleteRepositoriesForInstance(Integer fisheyeInstanceId) {
        this.serialiseRepositories(Collections.emptyList(), fisheyeInstanceId);
    }

    @Override
    public void setProjectRepositoryAssociations(Set projectKeys, String repositoryName, Integer fisheyeInstanceId) {
        String key = "fisheye.rep." + repositoryName + ".projects";
        this.properties.setString(key, this.properties.serialiseCollection(projectKeys), fisheyeInstanceId);
        this.reloadRepositories();
    }

    @Override
    public void associateProjectWithRepository(String projectKey, String repositoryName, Integer fisheyeInstanceId) {
        String key = "fisheye.rep." + repositoryName + ".projects";
        String projectString = this.properties.getText(key, fisheyeInstanceId);
        HashSet projects = Sets.newHashSet(this.properties.parseCollection(projectString));
        if (projects.contains(projectKey)) {
            return;
        }
        projects.add(projectKey);
        this.properties.setString(key, this.properties.serialiseCollection(projects), fisheyeInstanceId);
        this.reloadRepositories();
    }

    @Override
    public void removeProjectFromRepository(String projectKey, String repositoryName, Integer fisheyeInstanceId) {
        String key = "fisheye.rep." + repositoryName + ".projects";
        String projectString = this.properties.getText(key, fisheyeInstanceId);
        Collection<String> projects = this.properties.parseCollection(projectString);
        if (!projects.contains(projectKey)) {
            return;
        }
        projects.remove(projectKey);
        this.properties.setString(key, this.properties.serialiseCollection(projects), fisheyeInstanceId);
        this.reloadRepositories();
    }

    @Override
    public void addRepositories(Collection<String> repositoryNames, Integer fisheyeInstanceId) {
        HashSet storedNames = Sets.newHashSet(this.properties.parseCollection(this.properties.getText("fisheye.repository.list", fisheyeInstanceId)));
        storedNames.addAll(repositoryNames);
        this.properties.setText("fisheye.repository.list", this.properties.serialiseCollection(storedNames), fisheyeInstanceId);
        this.reloadRepositories();
        this.setRepoLastUpdatedTime();
    }

    @Override
    public String getRepoListLastUpdatedTime() {
        return this.properties.getString("fisheye.repository.last.updated");
    }

    @Override
    public void addRepository(String repositoryName, Integer fisheyeInstanceId) {
        this.addRepositories(Collections.singleton(repositoryName), fisheyeInstanceId);
    }

    @EventListener
    public void onClearCache(ClearCacheEvent clearCacheEvent) {
        this.reloadRepositories();
    }
}

