/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeRepository;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class FishEyeRepositoryManagerImpl
implements FishEyeRepositoryManager {
    private final FishEyeRepositoryStore fishEyeRepositoryStore;

    public FishEyeRepositoryManagerImpl(FishEyeRepositoryStore fishEyeRepositoryStore) {
        this.fishEyeRepositoryStore = fishEyeRepositoryStore;
    }

    @Override
    public List<FishEyeRepository> load(FishEyeInstance fishEyeInstance) {
        return Lists.newArrayList(this.fishEyeRepositoryStore.getRepositoriesForInstance(fishEyeInstance.getId()));
    }

    @Override
    public FishEyeRepository load(FishEyeInstance fishEyeInstance, String repositoryName) {
        return this.fishEyeRepositoryStore.getRepository(repositoryName, fishEyeInstance.getId());
    }

    @Override
    public FishEyeRepository update(final FishEyeRepository fishEyeRepository) {
        Integer fisheyeInstanceId = fishEyeRepository.getInstance().getId();
        Collection<FishEyeRepository> currentRepos = this.fishEyeRepositoryStore.getRepositoriesForInstance(fisheyeInstanceId);
        HashSet newRepos = Sets.newHashSet((Iterable)Collections2.filter(currentRepos, (Predicate)new Predicate<FishEyeRepository>(){

            public boolean apply(FishEyeRepository input) {
                return !fishEyeRepository.getName().equals(input.getName());
            }
        }));
        newRepos.add(fishEyeRepository);
        this.fishEyeRepositoryStore.setRepositoriesForInstance(newRepos, fisheyeInstanceId);
        this.fishEyeRepositoryStore.reloadRepositories();
        return fishEyeRepository;
    }
}

