/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye;

import com.atlassian.jirafisheyeplugin.config.PropertySetHolder;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.opensymphony.module.propertyset.PropertySet;
import com.opensymphony.util.TextUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyePropertiesImpl
implements FishEyeProperties {
    private static Logger log = LoggerFactory.getLogger(FishEyePropertiesImpl.class);
    private static final Long FALSE = new Long(0L);
    private static final Long TRUE = new Long(1L);
    private final PropertySetHolder factory;

    public FishEyePropertiesImpl(PropertySetHolder factory) {
        this.factory = factory;
    }

    @Override
    public void setText(String key, String value) {
        this.setText(key, value, (Integer)null);
    }

    @Override
    public String getText(String key) {
        return this.getText(key, (Integer)null);
    }

    @Override
    public void setString(String key, String value) {
        this.setString(key, value, (Integer)null);
    }

    @Override
    public String getString(String key) {
        return this.getString(key, (Integer)null);
    }

    @Override
    public void setLong(String key, Long value) {
        this.setLong(key, value, (Integer)null);
    }

    @Override
    public Long getLong(String key) {
        return this.getLong(key, (Integer)null);
    }

    @Override
    public void removeProperty(String key) {
        this.removeProperty(key, (Integer)null);
    }

    @Override
    public Boolean getBoolean(String key) {
        return this.getBoolean(key, (Integer)null);
    }

    @Override
    public void setBoolean(String key, Boolean value) {
        this.setBoolean(key, value, (Integer)null);
    }

    @Override
    public boolean getBooleanPrimitive(String key) {
        return this.getBooleanPrimitive(key, null);
    }

    @Override
    public String getText(String key, Integer fisheyeInstanceId) {
        key = FishEyePropertiesImpl.updateKey(key, fisheyeInstanceId);
        String value = this.getPropertySet().getText(key);
        if (!TextUtils.stringSet((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public void setText(String key, String value, Integer fisheyeInstanceId) {
        if (!TextUtils.stringSet((String)value)) {
            this.removeProperty(key, fisheyeInstanceId);
        } else {
            key = FishEyePropertiesImpl.updateKey(key, fisheyeInstanceId);
            this.getPropertySet().setText(key, value);
        }
    }

    @Override
    public String getString(String key, Integer fisheyeInstanceId) {
        key = FishEyePropertiesImpl.updateKey(key, fisheyeInstanceId);
        String value = this.getPropertySet().getString(key);
        if (!TextUtils.stringSet((String)value)) {
            return null;
        }
        return value;
    }

    @Override
    public void setString(String key, String value, Integer fisheyeInstanceId) {
        if (!TextUtils.stringSet((String)value)) {
            this.removeProperty(key, fisheyeInstanceId);
        } else {
            key = FishEyePropertiesImpl.updateKey(key, fisheyeInstanceId);
            this.getPropertySet().setString(key, value);
        }
    }

    @Override
    public void removeProperty(String key, Integer fisheyeInstanceId) {
        key = FishEyePropertiesImpl.updateKey(key, fisheyeInstanceId);
        if (this.getPropertySet().exists(key)) {
            this.getPropertySet().remove(key);
        }
    }

    @Override
    public void setLong(String key, Long value, Integer fisheyeInstanceId) {
        this.setString(key, value == null ? null : value.toString(), fisheyeInstanceId);
    }

    @Override
    public Long getLong(String key, Integer fisheyeInstanceId) {
        String property = this.getString(key, fisheyeInstanceId);
        if (property == null) {
            return null;
        }
        try {
            return new Long(property);
        }
        catch (NumberFormatException nfe) {
            throw new RuntimeException("Property " + key + " must be a valid integer. Found '" + property + "'");
        }
    }

    @Override
    public Boolean getBoolean(String key, Integer fisheyeInstanceId) {
        Long longValue = this.getLong(key, fisheyeInstanceId);
        if (longValue == null) {
            return null;
        }
        return longValue.intValue() > 0;
    }

    @Override
    public void setBoolean(String key, Boolean value, Integer fisheyeInstanceId) {
        if (value == null) {
            this.removeProperty(key, fisheyeInstanceId);
            return;
        }
        this.setLong(key, value != false ? TRUE : FALSE, fisheyeInstanceId);
    }

    @Override
    public boolean getBooleanPrimitive(String key, Integer fisheyeInstanceId) {
        Boolean bool = this.getBoolean(key, fisheyeInstanceId);
        return bool != null && bool != false;
    }

    @Override
    public void setText(String projectKey, String key, String value) {
        this.setText(FishEyePropertiesImpl.updateKey(key, projectKey), value);
    }

    @Override
    public String getText(String projectKey, String key) {
        return this.getText(FishEyePropertiesImpl.updateKey(key, projectKey));
    }

    @Override
    public void setString(String projectKey, String key, String value) {
        this.setString(FishEyePropertiesImpl.updateKey(key, projectKey), value);
    }

    @Override
    public String getString(String projectKey, String key) {
        return this.getString(FishEyePropertiesImpl.updateKey(key, projectKey));
    }

    @Override
    public void setLong(String projectKey, String key, Long value) {
        this.setLong(FishEyePropertiesImpl.updateKey(key, projectKey), value);
    }

    @Override
    public Long getLong(String projectKey, String key) {
        return this.getLong(FishEyePropertiesImpl.updateKey(key, projectKey));
    }

    @Override
    public void setBoolean(String projectKey, String key, Boolean value) {
        this.setBoolean(FishEyePropertiesImpl.updateKey(key, projectKey), value);
    }

    @Override
    public Boolean getBoolean(String projectKey, String key) {
        return this.getBoolean(FishEyePropertiesImpl.updateKey(key, projectKey));
    }

    @Override
    public void removeProperty(String projectKey, String key) {
        this.removeProperty(FishEyePropertiesImpl.updateKey(projectKey, key));
    }

    protected PropertySet getPropertySet() {
        return this.factory.get();
    }

    public static String updateKey(String propertyKey, String projectKey) {
        return propertyKey.replaceAll("%PRJ%", projectKey);
    }

    public static String updateKey(String propertyKey, Integer fisheyeInstanceId) {
        if (fisheyeInstanceId == null || fisheyeInstanceId == 0) {
            return propertyKey;
        }
        return propertyKey.replaceFirst("fisheye\\.", "fisheye." + fisheyeInstanceId + ".");
    }

    @Override
    public Collection<String> parseCollection(String text) {
        TreeSet<String> collection = new TreeSet<String>();
        if (text == null) {
            return collection;
        }
        StringTokenizer toks = new StringTokenizer(text, ", ");
        while (toks.hasMoreTokens()) {
            collection.add(toks.nextToken());
        }
        return collection;
    }

    @Override
    public Map parseMap(String text) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (text == null) {
            return map;
        }
        StringTokenizer toks = new StringTokenizer(text, ",");
        while (toks.hasMoreTokens()) {
            String key = toks.nextToken();
            if (!toks.hasMoreTokens()) {
                log.error("Supplied text '" + text + "' has uneven number of delimited elements - not suitable for Map");
                return map;
            }
            String value = toks.nextToken();
            map.put(key, value);
        }
        return map;
    }

    @Override
    public String serialiseCollection(Collection c) {
        StringBuilder buff = new StringBuilder();
        Iterator iterator = c.iterator();
        while (iterator.hasNext()) {
            Object o = iterator.next();
            buff.append(o.toString());
            if (!iterator.hasNext()) continue;
            buff.append(", ");
        }
        return buff.toString();
    }

    @Override
    public String serialiseMap(Map m) {
        StringBuilder buff = new StringBuilder();
        Iterator iterator = m.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e = iterator.next();
            if (e.getKey() == null || e.getValue() == null) {
                log.error("Cannot serialise (null key/value) entry=[" + e.getKey() + ":" + e.getValue() + "]");
                continue;
            }
            buff.append(e.getKey().toString()).append(",").append(e.getValue().toString());
            if (!iterator.hasNext()) continue;
            buff.append(",");
        }
        return buff.toString();
    }

    @Override
    public Collection<String> getCollection(String key) {
        return this.parseCollection(this.getText(key));
    }

    @Override
    public Collection<String> getCollection(String key, Integer fisheyeInstanceId) {
        return this.parseCollection(this.getText(key, fisheyeInstanceId));
    }

    @Override
    public void setCollection(String key, Collection collection) {
        this.setText(key, this.serialiseCollection(collection));
    }

    @Override
    public void setCollection(String key, Collection collection, Integer fisheyeInstanceId) {
        this.setText(key, this.serialiseCollection(collection), fisheyeInstanceId);
    }

    @Override
    public Map getMap(String key) {
        return this.parseMap(this.getText(key));
    }

    @Override
    public Map getMap(String key, Integer fisheyeInstanceId) {
        return this.parseMap(this.getText(key, fisheyeInstanceId));
    }

    @Override
    public void setMap(String key, Map map) {
        this.setText(key, this.serialiseMap(map));
    }

    @Override
    public void setMap(String key, Map map, Integer fisheyeInstanceId) {
        this.setText(key, this.serialiseMap(map), fisheyeInstanceId);
    }

    @Override
    public void refresh() {
        this.factory.reset();
    }
}

