/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual.ApplicationLinkIdMapper;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstanceImpl;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.util.ConfigUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeInstanceStoreImpl
implements FishEyeInstanceStore,
FishEyePropertyKeys {
    private static Logger log = LoggerFactory.getLogger(FishEyeInstanceStoreImpl.class);
    private final FishEyeProperties properties;
    private final ConfigUtil configUtil;
    private final ApplicationLinkIdMapper applicationLinkIdMapper;
    private Map instancesByUrl = new HashMap();
    private List cruStandaloneInstances;
    private Integer defaultInstanceId = null;

    public FishEyeInstanceStoreImpl(FishEyeProperties fisheyeProperties, ConfigUtil configUtil, ApplicationLinkIdMapper applicationLinkIdMapper) {
        this.properties = fisheyeProperties;
        this.configUtil = configUtil;
        this.applicationLinkIdMapper = applicationLinkIdMapper;
    }

    @Override
    public FishEyeInstance getDefaultFishEyeInstance() {
        return this.getFishEyeInstance(this.defaultInstanceId);
    }

    @Override
    public Integer getDefaultInstanceId() {
        return this.defaultInstanceId;
    }

    @Override
    public void addFishEyeInstance(FishEyeInstance instance) {
        if (Collections2.transform(this.getAllFishEyeInstances(), (Function)new Function<FishEyeInstance, String>(){

            public String apply(FishEyeInstance from) {
                return from.getUrl();
            }
        }).contains(instance.getUrl())) {
            throw new IllegalArgumentException(String.format("Cannot add an instance that already exists: trying to add [%s], but the url already exists", instance));
        }
        this.storeFishEyeInstance(instance);
    }

    @Override
    public void deleteFishEyeInstance(FishEyeInstance instance) {
        Integer id = instance.getId();
        boolean isDefault = id.equals(this.getDefaultInstanceId());
        this.properties.removeProperty("fisheye.text.api.url", id);
        this.properties.removeProperty("fisheye.text.url", id);
        this.properties.removeProperty("fisheye.api.connection.timeout", id);
        this.properties.removeProperty("fisheye.api.socket.timeout", id);
        this.properties.removeProperty("fisheye.api.connection.poolsize", id);
        this.properties.removeProperty("fisheye.charset", id);
        this.properties.removeProperty("fisheye.crucible.enabled", id);
        this.properties.removeProperty("fisheye.username", id);
        this.properties.removeProperty("fisheye.password", id);
        this.properties.removeProperty("fisheye.http.basic.username", id);
        this.properties.removeProperty("fisheye.http.basic.password", id);
        this.properties.removeProperty("fisheye.refreshed", id);
        if (id != null) {
            Collection<String> ids = this.properties.parseCollection(this.properties.getText("fisheye.instance.list"));
            ids.remove(id.toString());
            this.properties.setText("fisheye.instance.list", this.properties.serialiseCollection(ids));
        }
        if (isDefault && this.getAllFishEyeInstances().size() > 0) {
            this.chooseDefault();
        }
    }

    @Override
    public int getNextInstanceId() {
        Collection<String> ids = this.properties.parseCollection(this.properties.getText("fisheye.instance.list"));
        int last = 0;
        Iterator<String> it = ids.iterator();
        while (it.hasNext()) {
            int id = Integer.parseInt(it.next());
            if (id <= last) continue;
            last = id;
        }
        return last + 1;
    }

    @Override
    public void addInstanceId(Integer id) {
        String instanceList = this.properties.getText("fisheye.instance.list");
        Collection<String> ids = this.properties.parseCollection(instanceList);
        if (ids.contains(id.toString())) {
            return;
        }
        instanceList = instanceList == null ? id.toString() : instanceList + ", " + id.toString();
        this.properties.setText("fisheye.instance.list", instanceList);
    }

    @Override
    public void updateFishEyeInstance(FishEyeInstance instance) {
        this.storeFishEyeInstance(instance);
    }

    void storeFishEyeInstance(FishEyeInstance instance) {
        Integer id = instance.getId();
        this.properties.setText("fisheye.text.url", instance.getUrl(), id);
        this.properties.setText("fisheye.text.api.url", instance.getApiUrl(), id);
        if (instance.getCharset() != null) {
            this.properties.setString("fisheye.charset", instance.getCharset().name(), id);
        } else {
            this.properties.removeProperty("fisheye.charset", id);
        }
        this.properties.setString("fisheye.username", instance.getUsername(), id);
        this.properties.setString("fisheye.password", instance.getPassword(), id);
        this.properties.setString("fisheye.http.basic.username", instance.getBasicHttpAuthUsername(), id);
        this.properties.setString("fisheye.http.basic.password", instance.getBasicHttpAuthPassword(), id);
        this.properties.setLong("fisheye.api.socket.timeout", instance.getSocketTimeout() != -1 ? new Long(instance.getSocketTimeout()) : null, id);
        this.properties.setLong("fisheye.api.connection.timeout", instance.getConnectionTimeout() != -1 ? new Long(instance.getConnectionTimeout()) : null, id);
        this.properties.setLong("fisheye.crucible.enabled", instance.isCruStandalone() ? 2L : (long)(instance.isCru() ? 1 : 0), id);
        this.properties.setBoolean("fisheye.refreshed", instance.isHasBeenInitialised(), id);
        this.properties.setText("fisheye.text.name", instance.getName(), id);
        if (id != null && id > 0 && this.instanceDoesNotExist(id)) {
            this.addInstanceId(id);
        }
    }

    private boolean instanceDoesNotExist(final Integer id) {
        return Collections2.filter((Collection)Collections2.transform(this.properties.parseCollection(this.properties.getText("fisheye.instance.list")), (Function)new Function<String, Integer>(){

            public Integer apply(String from) {
                return Integer.valueOf(from);
            }
        }), (Predicate)new Predicate<Integer>(){

            public boolean apply(Integer input) {
                return id.equals(input);
            }
        }).isEmpty();
    }

    @Override
    public FishEyeInstance getFishEyeInstance(Integer id) {
        if (id == null) {
            id = this.defaultInstanceId;
        }
        String rawBaseUrl = this.properties.getText("fisheye.text.url", id);
        ApplicationId applicationId = this.applicationLinkIdMapper.fromInstanceId(id);
        if (rawBaseUrl == null) {
            return null;
        }
        boolean isCru = false;
        boolean isCruStandalone = false;
        Long cru = this.properties.getLong("fisheye.crucible.enabled", id);
        if (cru != null) {
            switch (cru.intValue()) {
                case 2: {
                    isCruStandalone = true;
                }
                case 1: {
                    isCru = true;
                }
            }
        }
        String displayUrl = this.configUtil.resolveUrl(rawBaseUrl);
        String rpcUrl = this.configUtil.resolveRpcUrl(this.properties.getText("fisheye.text.api.url", id), displayUrl);
        Boolean hasBeenInitialised = this.properties.getBoolean("fisheye.refreshed", id);
        String name = this.properties.getText("fisheye.text.name", id);
        if (name == null) {
            name = id == null ? "0" : String.valueOf(id);
        }
        return new FishEyeInstanceImpl(id == null ? 0 : id, name, isCru, isCruStandalone, displayUrl, rpcUrl, this.configUtil.resolveCharset(this.properties.getString("fisheye.charset", id)), this.properties.getString("fisheye.username", id), this.properties.getString("fisheye.password", id), this.properties.getString("fisheye.http.basic.username", id), this.properties.getString("fisheye.http.basic.password", id), this.configUtil.retrieveValidatedIntWithServerId("fisheye.api.socket.timeout", -1, id), this.configUtil.retrieveValidatedIntWithServerId("fisheye.api.connection.timeout", -1, id), applicationId, hasBeenInitialised == null ? true : hasBeenInitialised);
    }

    @Override
    public List getAuxiliaryFishEyeInstances() {
        Collection<String> ids = this.properties.parseCollection(this.properties.getText("fisheye.instance.list"));
        if (this.defaultInstanceId != null) {
            ids.remove(this.defaultInstanceId.toString());
        }
        return this.getFishEyeInstances(ids);
    }

    @Override
    public List<FishEyeInstance> getAllFishEyeInstances() {
        FishEyeInstance defaultInstance;
        Collection<String> ids = this.properties.parseCollection(this.properties.getText("fisheye.instance.list"));
        List<FishEyeInstance> instances = this.getFishEyeInstances(ids);
        if (this.defaultInstanceId == null && (defaultInstance = this.getDefaultFishEyeInstance()) != null) {
            instances.add(this.getDefaultFishEyeInstance());
        }
        return instances;
    }

    private List<FishEyeInstance> getFishEyeInstances(Collection ids) {
        ArrayList<FishEyeInstance> instances = new ArrayList<FishEyeInstance>(ids.size());
        Iterator it = ids.iterator();
        while (it.hasNext()) {
            Integer id = new Integer((String)it.next());
            FishEyeInstance instance = this.getFishEyeInstance(id);
            if (instance == null) continue;
            instances.add(instance);
        }
        return instances;
    }

    @Override
    public FishEyeInstance getFishEyeInstanceByUrl(String url) {
        if (url == null) {
            return null;
        }
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        return (FishEyeInstance)this.instancesByUrl.get(url);
    }

    private void chooseDefault() {
        List<FishEyeInstance> all;
        if (this.getDefaultFishEyeInstance() == null && !(all = this.getAllFishEyeInstances()).isEmpty()) {
            this.defaultInstanceId = ((FishEyeInstance)all.iterator().next()).getId();
        }
    }

    @Override
    public void refresh() {
        this.cruStandaloneInstances = null;
        this.instancesByUrl.clear();
        for (FishEyeInstance instance : this.getAllFishEyeInstances()) {
            this.instancesByUrl.put(instance.getUrl(), instance);
        }
        this.chooseDefault();
    }

    @Override
    public synchronized Collection getCrucibleStandaloneInstances() {
        if (this.cruStandaloneInstances == null) {
            this.cruStandaloneInstances = new ArrayList();
            for (FishEyeInstance fe : this.getAllFishEyeInstances()) {
                if (!fe.isCruStandalone()) continue;
                this.cruStandaloneInstances.add(fe);
            }
        }
        return this.cruStandaloneInstances;
    }

    @Override
    public void markInstanceUpgraded(FishEyeInstance inst) {
        this.properties.setBoolean("fisheye.ual.upgrade.completed", true, inst.getId());
    }
}

