/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.fecru.FishEyeCrucibleApplicationType;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeRepositoryStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.ual.ApplicationLinkIdMapper;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstanceBuilder;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeInstanceImpl;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.FishEyeManager;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.domain.fisheye.ServerInfo;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.command.RestCommand;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.rest.command.RestCommandFactory;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.net.ResponseHandler;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.mutable.MutableBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeInstanceManagerImpl
implements FishEyeInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(FishEyeInstanceManagerImpl.class);
    private final FishEyeInstanceStore fishEyeInstanceStore;
    private final ApplicationLinkIdMapper applicationLinkIdMapper;
    private final FishEyeManager fishEyeManager;
    private final FishEyeRepositoryStore fishEyeRepositoryStore;
    private final CrucibleProjectStore crucibleProjectStore;

    public FishEyeInstanceManagerImpl(FishEyeInstanceStore fishEyeInstanceStore, ApplicationLinkIdMapper applicationLinkIdMapper, FishEyeManager fishEyeManager, FishEyeRepositoryStore fishEyeRepositoryStore, CrucibleProjectStore crucibleProjectStore) {
        this.fishEyeInstanceStore = fishEyeInstanceStore;
        this.applicationLinkIdMapper = applicationLinkIdMapper;
        this.fishEyeManager = fishEyeManager;
        this.fishEyeRepositoryStore = fishEyeRepositoryStore;
        this.crucibleProjectStore = crucibleProjectStore;
    }

    @Override
    public FishEyeInstance create(ApplicationLink applicationLink) {
        if (!(applicationLink.getType() instanceof FishEyeCrucibleApplicationType)) {
            throw new IllegalArgumentException(String.format("The application link '%s' does not point to a FishEye/Crucible instance", applicationLink.getName()));
        }
        FishEyeInstance instance = this.load(applicationLink.getId());
        if (instance != null) {
            throw new IllegalArgumentException(String.format("There is already a FishEyeInstance with applicationId=%s: %s", applicationLink.getId(), instance));
        }
        int newInstanceId = this.fishEyeInstanceStore.getNextInstanceId();
        ServerInfo serverInfo = this.fetchServerInfo(applicationLink);
        instance = new FishEyeInstanceImpl(newInstanceId, applicationLink.getName(), serverInfo.isCrucible(), serverInfo.isCrucibleStandalone(), applicationLink.getDisplayUrl().toString(), applicationLink.getRpcUrl().toString(), null, null, null, null, null, -1, -1, applicationLink.getId(), false);
        this.fishEyeInstanceStore.addFishEyeInstance(instance);
        this.applicationLinkIdMapper.associate(newInstanceId, applicationLink.getId());
        this.fishEyeInstanceStore.markInstanceUpgraded(instance);
        try {
            this.fetchRepositoryAndProjectLists(instance);
            instance = FishEyeInstanceBuilder.copyOf(instance).withHasBeenInitialised(true).build();
        }
        catch (IOException e) {
            log.error(String.format("Failed to get FishEye repositories or projects from '%s'", instance.getName()), (Throwable)e);
        }
        this.fishEyeInstanceStore.updateFishEyeInstance(instance);
        this.fishEyeManager.refreshConfig();
        return instance;
    }

    @Override
    public void fetchRepositoryAndProjectLists(FishEyeInstance instance) throws IOException {
        log.debug("Fetching repository and project lists from '{}'", (Object)instance.getName());
    }

    @Override
    public FishEyeInstance load(ApplicationId applicationId) {
        Integer instanceId = this.applicationLinkIdMapper.fromApplicationId(applicationId);
        return instanceId != null ? this.fishEyeInstanceStore.getFishEyeInstance(instanceId) : null;
    }

    @Override
    public void delete(FishEyeInstance fishEyeInstance) {
        this.applicationLinkIdMapper.dissociate(fishEyeInstance.getId(), fishEyeInstance.getApplicationId());
        this.crucibleProjectStore.clearProjectMappingsForInstance(fishEyeInstance.getId());
        this.fishEyeRepositoryStore.deleteRepositoriesForInstance(fishEyeInstance.getId());
        this.fishEyeInstanceStore.deleteFishEyeInstance(fishEyeInstance);
        this.fishEyeManager.refreshConfig();
    }

    @Override
    public void update(FishEyeInstance updatedFishEyeInstance) {
        FishEyeInstance oldInstance = this.fishEyeInstanceStore.getFishEyeInstance((Integer)Preconditions.checkNotNull((Object)updatedFishEyeInstance.getId()));
        if (oldInstance == null) {
            throw new IllegalArgumentException(String.format("Cannot update an instance that does not exist: [%s]", updatedFishEyeInstance));
        }
        if (!oldInstance.getApplicationId().equals((Object)updatedFishEyeInstance.getApplicationId())) {
            this.applicationLinkIdMapper.dissociate(updatedFishEyeInstance.getId(), oldInstance.getApplicationId());
            this.applicationLinkIdMapper.associate(updatedFishEyeInstance.getId(), updatedFishEyeInstance.getApplicationId());
        }
        this.fishEyeInstanceStore.updateFishEyeInstance(updatedFishEyeInstance);
        this.fishEyeManager.refreshConfig();
    }

    @Override
    public ServerInfo fetchServerInfo(ApplicationLink applicationLink) {
        log.debug("Attempting to fetch server info for '{}'", (Object)applicationLink.getName());
        RestCommand serverInfoCmd = RestCommandFactory.serverInfo();
        URI url = serverInfoCmd.makeAbsoluteURL(applicationLink.getRpcUrl().toString());
        boolean isCrucibleStandalone = this.anonymousRequestReturns404(applicationLink, serverInfoCmd);
        if (isCrucibleStandalone) {
            log.debug("Request to '{}' returned 404. Assuming Crucible standalone", (Object)url);
            return ServerInfo.crucibleStandalone();
        }
        try {
            return this.doAuthenticatedRequest(applicationLink, serverInfoCmd);
        }
        catch (CredentialsRequiredException e) {
            log.warn(String.format("Request to '%s' failed due to missing OAuth credentials. Assuming FishEye+Crucible both available", url), (Throwable)e);
            return ServerInfo.fisheyeAndCrucible();
        }
        catch (ResponseException e) {
            log.warn(String.format("Request to '%s' failed. Assuming FishEye+Crucible both available", url), (Throwable)e);
            return ServerInfo.fisheyeAndCrucible();
        }
    }

    protected boolean anonymousRequestReturns404(ApplicationLink applicationLink, RestCommand command) {
        String url = command.makeAbsoluteURL(applicationLink.getRpcUrl()).toString();
        Request request = Anonymous.createAnonymousRequest((ApplicationLink)applicationLink, (Request.MethodType)command.getMethodType(), (String)url);
        final MutableBoolean requestReturned404 = new MutableBoolean(false);
        try {
            log.debug("Making request to {}", (Object)url);
            request.execute(new ResponseHandler(){

                public void handle(Response response) throws ResponseException {
                    if (log.isTraceEnabled()) {
                        log.trace("Server response is: {}", (Object)response.getResponseBodyAsString());
                    }
                    requestReturned404.setValue(response.getStatusCode() == 404);
                }
            });
        }
        catch (ResponseException e) {
            log.debug(String.format("Error while performing GET request to '%s'", url), (Throwable)e);
        }
        return requestReturned404.booleanValue();
    }

    protected ServerInfo doAuthenticatedRequest(ApplicationLink applicationLink, RestCommand command) throws ResponseException, CredentialsRequiredException {
        final URI url = command.makeAbsoluteURL(applicationLink.getRpcUrl().toString());
        ApplicationLinkRequestFactory requestFactory = applicationLink.createAuthenticatedRequestFactory();
        ApplicationLinkRequest request = (ApplicationLinkRequest)requestFactory.createRequest(Request.MethodType.GET, url.toString()).setFollowRedirects(true);
        log.debug("Making request to '{}'", (Object)url);
        return (ServerInfo)request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<ServerInfo>(){

            public ServerInfo credentialsRequired(Response response) throws ResponseException {
                log.warn("Request to '{}' requires OAuth credentials. Assuming FishEye+Crucible both available", (Object)url);
                return ServerInfo.fisheyeAndCrucible();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerInfo handle(Response response) throws ResponseException {
                if (log.isTraceEnabled()) {
                    log.trace("Server response is: {}", (Object)response.getResponseBodyAsString());
                }
                if (response.getStatusCode() == 404) {
                    log.debug("Request to '{}' returned 404. Assuming Crucible standalone", (Object)url);
                    return ServerInfo.crucibleStandalone();
                }
                if (response.isSuccessful()) {
                    InputStream inputStream = response.getResponseBodyAsStream();
                    try {
                        ServerInfo serverInfo = ServerInfo.fromXML(inputStream);
                        log.debug("Request to '{}' returned {}", (Object)url, (Object)serverInfo);
                        ServerInfo serverInfo2 = serverInfo;
                        return serverInfo2;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                    }
                }
                log.warn("Request to '{}' returned status code {}. Assuming FishEye+Crucible both available", (Object)url, (Object)response.getStatusCode());
                return ServerInfo.fisheyeAndCrucible();
            }
        });
    }
}

