/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye;

import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeConfig;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeInstanceStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyePropertyKeys;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.util.ConfigUtil;
import com.opensymphony.util.TextUtils;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FishEyeConfigImpl
implements FishEyeConfig,
FishEyePropertyKeys {
    private static Logger log = LoggerFactory.getLogger(FishEyeConfigImpl.class);
    private final FishEyeProperties properties;
    private final ConfigUtil configUtil;
    private final FishEyeInstanceStore fishEyeInstanceStore;
    private boolean isValid = true;
    private int revisionCacheSize;
    private Charset defaultCharset;
    private int maxIssueChangeSets;
    private int maxProjectChangeSets;
    private int maxRevisions;
    private int maxDaysPrevious;
    private int maxCruDaysSearch;
    private Map cruProjectsToUrls = new HashMap();
    private boolean useCruTextSearch;
    private boolean useCruChangesetSearch;
    private boolean searchForMovedIssues;
    private boolean wikiRendering;

    public FishEyeConfigImpl(FishEyeProperties fisheyeProperties, ConfigUtil configUtil, FishEyeInstanceStore fishEyeInstanceStore) {
        this.properties = fisheyeProperties;
        this.configUtil = configUtil;
        this.fishEyeInstanceStore = fishEyeInstanceStore;
    }

    @Override
    public boolean isValid() {
        if (!this.isValid && log.isDebugEnabled()) {
            log.debug("FishEyeConfigImpl.isValid() is returning false, dumping config values:");
            log.debug("fisheye.charset=" + this.defaultCharset);
            log.debug("fisheye.max.previous.days.search=" + this.maxDaysPrevious);
            log.debug("fisheye.crucible.max.days.search=" + this.maxCruDaysSearch);
            log.debug("fisheye.display.issue.maxchangesets=" + this.maxIssueChangeSets);
            log.debug("fisheye.display.project.maxchangesets=" + this.maxProjectChangeSets);
            log.debug("fisheye.display.maxrevisions=" + this.maxRevisions);
            log.debug("fisheye.revcache.size=" + this.revisionCacheSize);
        }
        return this.isValid;
    }

    @Override
    public int getRevisionCacheSize() {
        return this.revisionCacheSize;
    }

    @Override
    public int getMaxIssueChangeSets() {
        return this.maxIssueChangeSets;
    }

    @Override
    public int getMaxProjectChangesets() {
        return this.maxProjectChangeSets;
    }

    @Override
    public int getMaxRevisions() {
        return this.maxRevisions;
    }

    @Override
    public int getMaxDaysPrevious() {
        return this.maxDaysPrevious;
    }

    @Override
    public int getMaxCruDaysSearch() {
        return this.maxCruDaysSearch;
    }

    @Override
    public Charset getDefaultCharset() {
        return this.defaultCharset;
    }

    @Override
    public boolean isTextCruSearch() {
        return this.useCruTextSearch;
    }

    @Override
    public boolean isChangesetCruSearch() {
        return this.useCruChangesetSearch;
    }

    @Override
    public boolean isWikiRenderingEnabled() {
        return this.wikiRendering;
    }

    @Override
    public boolean isSearchForMovedIssues() {
        return this.searchForMovedIssues;
    }

    @Override
    public void reloadProperties() {
        this.reloadPropertiesHelper();
    }

    private void reloadPropertiesHelper() {
        this.isValid = true;
        this.validateConfiguration();
        this.reloadIntegerParams();
        this.reloadDefaultCharset();
        this.reloadBooleanParams();
    }

    private void validateConfiguration() {
        Collection<String> ids = this.properties.parseCollection(this.properties.getText("fisheye.instance.list"));
        ids.add("0");
        for (String strId : ids) {
            try {
                Integer id = new Integer(strId);
                if (!TextUtils.stringSet((String)this.properties.getText("fisheye.text.url", id))) continue;
                return;
            }
            catch (NumberFormatException e) {
                log.warn("FishEyeInstance has non integer id: '" + strId + "'");
            }
        }
        this.isValid = false;
    }

    protected void reloadIntegerParams() {
        this.revisionCacheSize = this.configUtil.retrieveValidatedInt("fisheye.revcache.size", 100000, 5000);
        this.maxIssueChangeSets = this.configUtil.retrieveValidatedInt("fisheye.display.issue.maxchangesets", 20);
        this.maxProjectChangeSets = this.configUtil.retrieveValidatedInt("fisheye.display.project.maxchangesets", 20);
        this.maxRevisions = this.configUtil.retrieveValidatedInt("fisheye.display.maxrevisions", 30);
        this.maxDaysPrevious = this.configUtil.retrieveValidatedInt("fisheye.max.previous.days.search", 30);
        this.maxCruDaysSearch = this.configUtil.retrieveValidatedInt("fisheye.crucible.max.days.search", 20);
    }

    private void reloadBooleanParams() {
        this.useCruChangesetSearch = false;
        this.useCruTextSearch = false;
        String searchMethod = this.properties.getString("fisheye.crucible.search.method", this.fishEyeInstanceStore.getDefaultInstanceId());
        if ("cru.search.text.only".equals(searchMethod)) {
            this.useCruTextSearch = true;
        } else if ("cru.search.revision.only".equals(searchMethod)) {
            this.useCruChangesetSearch = true;
        } else {
            this.useCruTextSearch = true;
            this.useCruChangesetSearch = true;
        }
        Boolean searchMovedObj = this.properties.getBoolean("fisheye.search.moved.issues", this.fishEyeInstanceStore.getDefaultInstanceId());
        this.searchForMovedIssues = searchMovedObj == null || searchMovedObj != false;
        Boolean wikiRenderingObj = this.properties.getBoolean("fisheye.display.wiki.render", this.fishEyeInstanceStore.getDefaultInstanceId());
        this.wikiRendering = wikiRenderingObj != null && wikiRenderingObj != false;
    }

    protected void reloadDefaultCharset() {
        this.defaultCharset = this.configUtil.resolveCharset(this.properties.getString("fisheye.charset", this.fishEyeInstanceStore.getDefaultInstanceId()));
    }

    @Override
    public boolean isCrucibleEnabled() {
        return this.properties.getBooleanPrimitive("fisheye.crucible.enabled", this.fishEyeInstanceStore.getDefaultInstanceId());
    }

    public Map getCrucibleProjectToUrlMappings() {
        return Collections.unmodifiableMap(this.cruProjectsToUrls);
    }

    @Override
    public void setCrucibleProjectToUrlMappings(Map mappings) {
        this.cruProjectsToUrls = mappings;
    }
}

