/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible;

import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.crucible.CrucibleProjectStore;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.util.Util;
import java.util.Collection;
import java.util.Date;

public class CrucibleProjectStoreImpl
implements CrucibleProjectStore {
    private final FishEyeProperties properties;
    private final ProjectManager projectManager;
    private final JiraAuthenticationContext authenticationContext;

    public CrucibleProjectStoreImpl(FishEyeProperties properties, ProjectManager projectManager, JiraAuthenticationContext authenticationContext) {
        this.properties = properties;
        this.projectManager = projectManager;
        this.authenticationContext = authenticationContext;
    }

    @Override
    public Collection getMappedCrucibleProjectKeys(String crucibleProjectKey, Integer instanceId) {
        return this.properties.getCollection("fisheye.crucible." + crucibleProjectKey + ".projects", instanceId);
    }

    @Override
    public String getDefaultCrucibleProjectKey(String jiraProjectKey, Integer instanceId) {
        return this.properties.getString("fisheye.default.crucible.project." + jiraProjectKey, instanceId);
    }

    private void setDefaultCrucibleProject(String jiraProjectKey, String crucibleProjectKey, Integer instanceId) {
        this.properties.setString("fisheye.default.crucible.project." + jiraProjectKey, crucibleProjectKey, instanceId);
    }

    @Override
    public void setDefaultCrucibleProject(Collection jiraProjectKeys, String crucibleProjectKey, Integer instanceId) {
        this.properties.setCollection("fisheye.crucible." + crucibleProjectKey + ".projects", jiraProjectKeys, instanceId);
        for (String jiraKey : jiraProjectKeys) {
            this.setDefaultCrucibleProject(jiraKey, crucibleProjectKey, instanceId);
        }
    }

    @Override
    public void clearProjectMappingsForInstance(Integer instanceId) {
        for (Project project : this.projectManager.getProjectObjects()) {
            this.properties.removeProperty("fisheye.default.crucible.project." + project.getKey(), instanceId);
        }
    }

    public Collection getCrucibleProjectKeys(Integer instanceId) {
        Integer id = instanceId == null || instanceId == 0 ? 0 : instanceId;
        String serialisedCruProjects = this.properties.getText("fisheye.crucible.projects.all." + id + ".projects", instanceId);
        return this.properties.parseCollection(serialisedCruProjects);
    }

    @Override
    public void setCrucibleProjectKeys(Collection crucibleProjects, Integer instanceId) {
        Integer id = instanceId == null || instanceId == 0 ? 0 : instanceId;
        String key = "fisheye.crucible.projects.all." + id + ".projects";
        this.properties.setText(key, this.properties.serialiseCollection(crucibleProjects), instanceId);
        this.properties.setString("fisheye.crucible.projects.last.updated", Util.formatDate("EEE, d MMM yyyy HH:mm:ss Z", new Date(), this.authenticationContext.getLocale()));
    }

    @Override
    public String getCrucibleProjectKeysLastUpdated() {
        return this.properties.getString("fisheye.crucible.projects.last.updated");
    }
}

