/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.upgrade;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.util.AttachmentPathManager;
import com.atlassian.jira.config.util.JiraHome;
import com.atlassian.jira.event.ListenerManager;
import com.atlassian.jira.issue.index.IssueIndexManager;
import com.atlassian.jira.ofbiz.OfBizDelegator;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.service.ServiceManager;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.JiraUtils;
import com.atlassian.jira.util.collect.Sized;
import com.atlassian.jira.util.index.Contexts;
import com.atlassian.jira.util.johnson.JohnsonProvider;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jirafisheyeplugin.config.JiraFisheyeStartRefreshEvent;
import com.atlassian.jirafisheyeplugin.perforce.PerforceConfigStore;
import com.atlassian.jirafisheyeplugin.perforce.PerforceProperties;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeException;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeManager;
import com.atlassian.jirafisheyeplugin.upgrade.FishEyeUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.legacy.config.fisheye.FishEyeProperties;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.StringToTextPropertyUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.UpdateApiUrlPropertyTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.UpdateConditionsToPlugins2NamespaceTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.UpdatePortletNamespaceTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.UpdateRecentCommitsPropertyTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce.PerforceHiddenJobCheckboxUpdateTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce.PerforceJobCheckboxUpdateTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce.PerforceJobSearcherUpdateTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce.PerforceRemoveChangesIndexingServiceTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce.PerforceRemoveOldJobUpdateListenerTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce.PerforceUpdateCreateJobFunctionTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.perforce.PerforceUpgradeToMultipleInstanceFormatTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.ual.UalFullMigrationTask;
import com.atlassian.jirafisheyeplugin.upgrade.tasks.ual.UalUpgradeTask;
import com.atlassian.jirafisheyeplugin.upgrade.ual.CrucibleEnabledPropertyFixup;
import com.atlassian.jirafisheyeplugin.upgrade.ual.CrucibleEnabledPropertyFixupTask;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalCheckBypass;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalFullMigrator;
import com.atlassian.jirafisheyeplugin.upgrade.ual.UalUpgrader;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeFinishedEvent;
import com.atlassian.jirafisheyeplugin.upgrade.ual.event.UpgradeStartedEvent;
import com.atlassian.johnson.JohnsonEventContainer;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class FishEyeUpgradeManagerImpl
implements FishEyeUpgradeManager,
InitializingBean,
DisposableBean {
    private static Logger log = LoggerFactory.getLogger(FishEyeUpgradeManagerImpl.class);
    private final ApplicationProperties applicationProperties;
    private final IssueIndexManager issueIndexManager;
    private final EventPublisher eventPublisher;
    private final List<FishEyeUpgradeTask> tasks;
    private final I18nHelper i18nHelper;
    private final JohnsonProvider johnsonProvider;

    public FishEyeUpgradeManagerImpl(FishEyeProperties fisheyeProperties, WorkflowManager workflowManager, ListenerManager listenerManager, ServiceManager serviceManager, OfBizDelegator ofBizDelegator, ApplicationProperties applicationProperties, IssueIndexManager issueIndexManager, PerforceConfigStore perforceConfigStore, ProjectManager projectManager, PerforceProperties perforceProperties, JiraHome jiraHome, AttachmentPathManager attachmentPathManager, EventPublisher eventPublisher, UalCheckBypass ualCheckBypass, UalUpgrader ualUpgrader, UalFullMigrator ualFullMigrator, CrucibleEnabledPropertyFixup crucibleEnabledPropertyFixup, I18nHelper i18nHelper, JohnsonProvider johnsonProvider) {
        this.applicationProperties = applicationProperties;
        this.issueIndexManager = issueIndexManager;
        this.eventPublisher = eventPublisher;
        this.johnsonProvider = (JohnsonProvider)Preconditions.checkNotNull((Object)johnsonProvider, (Object)"johnsonProvider");
        this.i18nHelper = (I18nHelper)Preconditions.checkNotNull((Object)i18nHelper, (Object)"i18nHelper");
        LinkedList<FishEyeUpgradeTask> tasks = new LinkedList<FishEyeUpgradeTask>();
        tasks.add(new PerforceUpgradeToMultipleInstanceFormatTask(perforceConfigStore, fisheyeProperties, projectManager, perforceProperties, jiraHome, attachmentPathManager));
        tasks.add(new UpdatePortletNamespaceTask(ofBizDelegator));
        tasks.add(new StringToTextPropertyUpgradeTask(fisheyeProperties));
        tasks.add(new UpdateRecentCommitsPropertyTask(ofBizDelegator));
        tasks.add(new UpdateConditionsToPlugins2NamespaceTask(workflowManager, fisheyeProperties));
        tasks.add(new UpdateApiUrlPropertyTask(fisheyeProperties));
        tasks.add(new UalUpgradeTask(ualCheckBypass, ualUpgrader));
        tasks.add(new UalFullMigrationTask(ualFullMigrator, fisheyeProperties));
        tasks.add(new CrucibleEnabledPropertyFixupTask(crucibleEnabledPropertyFixup, fisheyeProperties));
        tasks.add(new PerforceJobCheckboxUpdateTask(ofBizDelegator));
        tasks.add(new PerforceHiddenJobCheckboxUpdateTask(ofBizDelegator));
        tasks.add(new PerforceJobSearcherUpdateTask(ofBizDelegator));
        tasks.add(new PerforceUpdateCreateJobFunctionTask(workflowManager, fisheyeProperties));
        tasks.add(new PerforceRemoveOldJobUpdateListenerTask(listenerManager, ofBizDelegator));
        tasks.add(new PerforceRemoveChangesIndexingServiceTask(serviceManager));
        this.tasks = Collections.unmodifiableList(tasks);
    }

    @EventListener
    public void start(JiraFisheyeStartRefreshEvent jiraFisheyeStartRefreshEvent) throws Exception {
        if (this.detectPerforcePlugin()) {
            log.warn("Not upgrading Perforce data until Perforce/FishEye plugin conflict is resolved.");
        } else {
            this.doUpgradesIfSetup();
        }
    }

    protected boolean detectPerforcePlugin() {
        if (this.isPerforcePluginOnClasspath()) {
            log.error("You can not have the JIRA Perforce plugin and JIRA FishEye plugin v1.6 or above installed at the same time. Please remove atlassian-jira-perforce-plugin-x.x.jar from WEB-INF/lib and restart JIRA");
            EventType type = new EventType(this.i18nHelper.getText("perforce.check.event.type.category"), this.i18nHelper.getText("perforce.check.event.type.description"));
            JohnsonEventContainer johnsonEventContainer = this.johnsonProvider.getContainer();
            johnsonEventContainer.addEvent(new Event(type, this.i18nHelper.getText("perforce.check.event.description"), EventLevel.get((String)"fatal")));
            return true;
        }
        return false;
    }

    protected void doUpgradesIfSetup() {
        if (JiraUtils.isSetup()) {
            this.doUpgrades();
        }
    }

    private boolean isPerforcePluginOnClasspath() {
        try {
            Class.forName("com.atlassian.jira.plugin.ext.perforce.PerforceManager");
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doUpgrades() {
        this.eventPublisher.publish((Object)new UpgradeStartedEvent());
        try {
            boolean requiresReindex = false;
            for (FishEyeUpgradeTask task : this.tasks) {
                if (task.isNeeded()) {
                    try {
                        log.info("Starting upgrade task: " + task.getName());
                        task.doUpgrade();
                        log.info("Completed upgrade task: " + task.getName());
                    }
                    catch (FishEyeUpgradeException e) {
                        log.error("Problem running upgrade task '" + task.getName() + "'", (Throwable)e);
                    }
                    if (requiresReindex) continue;
                    requiresReindex = task.reindexRequired();
                    continue;
                }
                log.info("Skipping upgrade task: " + task.getName());
            }
            if (requiresReindex) {
                this.reindexAll();
            }
        }
        finally {
            this.eventPublisher.publish((Object)new UpgradeFinishedEvent());
        }
    }

    private void reindexAll() {
        log.info("Re-index all data if indexing is turned on.");
        boolean indexingOn = this.applicationProperties.getOption("jira.option.indexing");
        if (!indexingOn) {
            log.warn("Could not re-index data after FishEye plugin upgrade - indexing is turned off.");
        } else {
            log.info("FishEye plugin upgrade requires full re-index - starting re-index process.");
            this.issueIndexManager.reIndexAll(Contexts.percentageLogger((Sized)this.issueIndexManager, (org.apache.log4j.Logger)org.apache.log4j.Logger.getLogger(FishEyeUpgradeManagerImpl.class)));
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }
}

