/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.stash;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.AuthorisationURIGenerator;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.application.stash.StashApplicationType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.IssueManager;
import com.atlassian.jira.plugin.devstatus.api.DevStatusSupportedApplicationLinkService;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.web.ExecutingHttpRequest;
import com.atlassian.jirafisheyeplugin.optionaldep.DevStatusSupportedAppLinksServiceAccessor;
import com.atlassian.jirafisheyeplugin.stash.Commit;
import com.atlassian.jirafisheyeplugin.stash.CommitParser;
import com.atlassian.jirafisheyeplugin.stash.CommitSearchResults;
import com.atlassian.jirafisheyeplugin.stash.CredentialsRequest;
import com.atlassian.jirafisheyeplugin.stash.IntegrationProblem;
import com.atlassian.jirafisheyeplugin.stash.Page;
import com.atlassian.jirafisheyeplugin.stash.StashCommitService;
import com.atlassian.jirafisheyeplugin.util.Util;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;

public class StashCommitServiceImpl
implements StashCommitService {
    public static final int MAX_COMMITS = 50;
    public static final int MAX_CHANGES = 5;
    public static final int AVATAR_SIZE = 32;
    private final ApplicationLinkService applicationLinkService;
    private final CommitParser commitParser;
    private final IssueManager issueManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final DevStatusSupportedAppLinksServiceAccessor devStatusSupportedAppLinksServiceAccessor;

    public StashCommitServiceImpl(ApplicationLinkService applicationLinkService, CommitParser commitParser, IssueManager issueManager, JiraAuthenticationContext jiraAuthenticationContext, DevStatusSupportedAppLinksServiceAccessor devStatusSupportedAppLinksServiceAccessor) {
        this.applicationLinkService = applicationLinkService;
        this.commitParser = commitParser;
        this.issueManager = issueManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.devStatusSupportedAppLinksServiceAccessor = devStatusSupportedAppLinksServiceAccessor;
    }

    @Override
    public CommitSearchResults findCommits(Issue issue) {
        ArrayList<Commit> commits = new ArrayList<Commit>();
        ArrayList<CredentialsRequest> credentialsRequests = new ArrayList<CredentialsRequest>();
        ArrayList<IntegrationProblem> problems = new ArrayList<IntegrationProblem>();
        ArrayList<ApplicationLink> serversWithTruncatedResults = new ArrayList<ApplicationLink>();
        int serversQueried = 0;
        for (String issueKey : this.issueManager.getAllIssueKeys(issue.getId())) {
            serversQueried += this.getCommits(commits, credentialsRequests, problems, serversWithTruncatedResults, issueKey);
        }
        return new CommitSearchResults(commits, credentialsRequests, problems, serversWithTruncatedResults, serversQueried);
    }

    private int getCommits(final List<Commit> commits, final List<CredentialsRequest> credentialsRequests, final List<IntegrationProblem> problems, final List<ApplicationLink> serversWithTruncatedResults, String issueKey) {
        int serversQueried = 0;
        for (final ApplicationLink stashLink : this.applicationLinkService.getApplicationLinks(StashApplicationType.class)) {
            try {
                ++serversQueried;
                final ApplicationLinkRequestFactory requestFactory = stashLink.createAuthenticatedRequestFactory();
                String commitsUri = "/rest/jira/1.0/issues/" + Util.uncheckedUrlEncode(issueKey) + "/commits" + "?maxChanges=" + 5 + "&limit=" + 50 + "&avatarScheme=" + this.detectJiraScheme() + "&avatarSize=" + 32 + "&useBaseUrlToken=true";
                ApplicationLinkRequest request = requestFactory.createRequest(Request.MethodType.GET, commitsUri);
                request.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<Void>(){

                    public Void credentialsRequired(Response response) throws ResponseException {
                        credentialsRequests.add(new CredentialsRequest(stashLink, (AuthorisationURIGenerator)requestFactory));
                        return null;
                    }

                    public Void handle(Response response) throws ResponseException {
                        String respJson;
                        if (!response.isSuccessful()) {
                            switch (response.getStatusCode()) {
                                case 404: {
                                    problems.add(new IntegrationProblem(stashLink, StashCommitServiceImpl.this.i18n().getText("stash.integration.problem.404.message", stashLink.getName())));
                                    break;
                                }
                                default: {
                                    problems.add(new IntegrationProblem(stashLink, StashCommitServiceImpl.this.i18n().getText("stash.integration.problem.error.message", String.valueOf(response.getStatusCode()), response.getStatusText())));
                                }
                            }
                            return null;
                        }
                        try {
                            respJson = IOUtils.toString((InputStream)response.getResponseBodyAsStream(), (String)"UTF-8");
                        }
                        catch (IOException e) {
                            problems.add(new IntegrationProblem(stashLink, StashCommitServiceImpl.this.i18n().getText("stash.read.response.failed", e.getLocalizedMessage())));
                            return null;
                        }
                        try {
                            Page<Commit> parsedCommits = StashCommitServiceImpl.this.commitParser.parseCommits(respJson, stashLink);
                            commits.addAll(parsedCommits.getItems());
                            if (parsedCommits.isTruncated()) {
                                serversWithTruncatedResults.add(stashLink);
                            }
                        }
                        catch (Exception e) {
                            problems.add(new IntegrationProblem(stashLink, StashCommitServiceImpl.this.i18n().getText("stash.parse.response.failed", e.getLocalizedMessage())));
                            return null;
                        }
                        return null;
                    }
                });
            }
            catch (CredentialsRequiredException e) {
                credentialsRequests.add(new CredentialsRequest(stashLink, (AuthorisationURIGenerator)e));
            }
            catch (ResponseException e) {
                if (this.hasNested(e, SocketTimeoutException.class)) {
                    problems.add(new IntegrationProblem(stashLink, this.i18n().getText("stash.integration.problem.socket.timeout.message", stashLink.getName())));
                    continue;
                }
                if (this.hasNested(e, ConnectException.class)) {
                    problems.add(new IntegrationProblem(stashLink, this.i18n().getText("stash.integration.problem.connect.timeout.message", stashLink.getName())));
                    continue;
                }
                problems.add(new IntegrationProblem(stashLink, this.i18n().getText("stash.integration.problem.response.error.message", e.getLocalizedMessage())));
            }
        }
        return serversQueried;
    }

    private boolean hasNested(Throwable throwable, Class<? extends Throwable> nestedType) {
        int depth = 0;
        do {
            if (!throwable.getClass().isAssignableFrom(nestedType)) continue;
            return true;
        } while ((throwable = throwable.getCause()) != null && throwable.getCause() != throwable && ++depth < 50);
        return false;
    }

    private I18nHelper i18n() {
        return this.jiraAuthenticationContext.getI18nHelper();
    }

    private String detectJiraScheme() {
        HttpServletRequest request = ExecutingHttpRequest.get();
        return request != null && "https".equalsIgnoreCase(request.getScheme()) ? "https" : "http";
    }

    @Override
    public boolean isConfigured() {
        return !Iterables.isEmpty((Iterable)this.applicationLinkService.getApplicationLinks(StashApplicationType.class));
    }

    @Override
    public boolean hasNoSummary() {
        DevStatusSupportedApplicationLinkService devStatusSupportedAppLinksService = (DevStatusSupportedApplicationLinkService)this.devStatusSupportedAppLinksServiceAccessor.getService();
        return devStatusSupportedAppLinksService == null || !devStatusSupportedAppLinksService.hasApplicationTypeFull2LOSupport(StashApplicationType.class);
    }
}

