/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.stash;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.jirafisheyeplugin.stash.Author;
import com.atlassian.jirafisheyeplugin.stash.Change;
import com.atlassian.jirafisheyeplugin.stash.Commit;
import com.atlassian.jirafisheyeplugin.stash.CommitParser;
import com.atlassian.jirafisheyeplugin.stash.Page;
import com.atlassian.jirafisheyeplugin.stash.PageImpl;
import com.atlassian.jirafisheyeplugin.stash.StashProject;
import com.atlassian.jirafisheyeplugin.stash.StashRepository;
import com.atlassian.jirafisheyeplugin.util.Util;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.jayway.jsonpath.InvalidJsonException;
import com.jayway.jsonpath.JsonPath;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitParserV1
implements CommitParser {
    private static final Logger log = LoggerFactory.getLogger(CommitParserV1.class);
    private static final JsonPath pageCommits = JsonPath.compile("$.values[*]");
    private static final JsonPath pageIsLastPage = JsonPath.compile("$.isLastPage");
    private static final JsonPath commitAuthor = JsonPath.compile("$.toCommit.author");
    private static final JsonPath commitDisplayHash = JsonPath.compile("$.toCommit.displayId");
    private static final JsonPath commitMessage = JsonPath.compile("$.toCommit.message");
    private static final JsonPath commitDate = JsonPath.compile("$.toCommit.authorTimestamp");
    private static final JsonPath commitChanges = JsonPath.compile("$.changes.values[*]");
    private static final JsonPath commitIsLastPage = JsonPath.compile("$.changes.isLastPage");
    private static final JsonPath commitRepository = JsonPath.compile("$.repository");
    private static final JsonPath commitParents = JsonPath.compile("$.toCommit.parents[*]");
    private static final JsonPath authorName = JsonPath.compile("$.name");
    private static final JsonPath authorEmailAddress = JsonPath.compile("$.emailAddress");
    private static final JsonPath authorAvatarUrl = JsonPath.compile("$.avatarUrl");
    private static final JsonPath changePath = JsonPath.compile("$.path.toString");
    private static final JsonPath changeType = JsonPath.compile("$.type");
    private static final JsonPath repositoryName = JsonPath.compile("$.name");
    private static final JsonPath repositoryProject = JsonPath.compile("$.project");
    private static final JsonPath projectKey = JsonPath.compile("$.key");
    private static final JsonPath projectName = JsonPath.compile("$.name");
    private static final JsonPath links = JsonPath.compile("$.links");
    private static final JsonPath linksSelfHref = JsonPath.compile("$.links.self[0].href");
    private static final JsonPath linkUrl = JsonPath.compile("$.link.url");

    @Override
    public Page<Commit> parseCommits(String jsonPage, final ApplicationLink stashLink) throws InvalidJsonException {
        ImmutableList commitList = ImmutableList.copyOf((Collection)Lists.transform((List)((List)pageCommits.read(jsonPage)), (Function)new Function<Object, Commit>(){

            public Commit apply(Object jsonCommit) {
                JsonWrapper commit = new JsonWrapper(jsonCommit, stashLink);
                return new Commit(commit.parseString(commitDisplayHash), CommitParserV1.this.parseAuthor(commit.getChildAtNode(commitAuthor)), commit.parseSelfLink(), commit.parseString(commitMessage), CommitParserV1.this.isMerge(commit), CommitParserV1.this.parseChanges(jsonCommit, stashLink), commit.parseDate(commitDate), CommitParserV1.this.parseRepository(commit.getChildAtNode(commitRepository)));
            }
        }));
        boolean isTruncated = (Boolean)pageIsLastPage.read(jsonPage) == false;
        return new PageImpl<Commit>((List<Commit>)commitList, isTruncated);
    }

    private boolean isMerge(JsonWrapper commit) {
        return ((List)commit.parseValue(commitParents)).size() > 1;
    }

    private StashRepository parseRepository(JsonWrapper repository) {
        JsonWrapper project = repository.getChildAtNode(repositoryProject);
        return new StashRepository(repository.parseString(repositoryName), repository.parseUrl(), new StashProject(project.parseString(projectKey), project.parseString(projectName), project.parseUrl()));
    }

    private Author parseAuthor(JsonWrapper author) {
        return new Author(author.parseString(authorName), author.parseString(authorEmailAddress), author.parseUrlWithBaseUrlTokenParameters(authorAvatarUrl));
    }

    private Page<Change> parseChanges(Object jsonCommits, final ApplicationLink stashLink) {
        ImmutableList changes = ImmutableList.copyOf((Collection)Lists.transform((List)((List)commitChanges.read(jsonCommits)), (Function)new Function<Object, Change>(){

            public Change apply(Object jsonChange) {
                return CommitParserV1.this.parseChange(new JsonWrapper(jsonChange, stashLink));
            }
        }));
        boolean isTruncated = (Boolean)commitIsLastPage.read(jsonCommits) == false;
        return new PageImpl<Change>((List<Change>)changes, isTruncated);
    }

    private Change parseChange(JsonWrapper change) {
        return new Change(change.parseString(changePath), change.parseSelfLink(), change.parseEnumValue(changeType, Change.ChangeType.class, Change.ChangeType.UNKNOWN));
    }

    private static class JsonWrapper {
        private final Object json;
        private final ApplicationLink stashLink;

        private JsonWrapper(Object json, ApplicationLink stashLink) {
            this.json = json;
            this.stashLink = stashLink;
        }

        public <T> T parseValue(JsonPath path) {
            Object value = path.read(this.json);
            if (value == null) {
                log.debug(String.format("Expected value at %s was missing in response from Bitbucket Server %s.", path.getPath(), this.stashLink.getName()));
            }
            return value;
        }

        public String parseString(JsonPath pathToString) {
            return (String)this.parseValue(pathToString);
        }

        public String parseUrl() {
            if (this.parseValue(links) != null) {
                return this.parseUrlWithBaseUrlTokenParameters(linksSelfHref);
            }
            return this.parseUrlAndAddContext(linkUrl);
        }

        private String parseUrlAndAddContext(JsonPath pathToUrlWithoutContext) {
            String urlWithoutContext = this.parseString(pathToUrlWithoutContext);
            if (urlWithoutContext == null) {
                return null;
            }
            return this.stashLink.getDisplayUrl().toASCIIString() + urlWithoutContext;
        }

        public String parseUrlWithBaseUrlTokenParameters(JsonPath pathToUrl) {
            String urlWithTokens = this.parseString(pathToUrl);
            if (urlWithTokens == null) {
                return null;
            }
            return urlWithTokens.replaceAll("\\$\\$\\$\\$stash\\.baseUrl%\\$\\$\\$\\$", this.stashLink.getDisplayUrl().toString()).replaceAll("\\$\\$\\$\\$stash\\.baseUrl%25\\$\\$\\$\\$", Util.utf8Encode(this.stashLink.getDisplayUrl()));
        }

        public String parseSelfLink() {
            return this.parseUrl();
        }

        public Date parseDate(JsonPath pathToLong) {
            Long longVal = (Long)this.parseValue(pathToLong);
            return longVal != null ? new Date(longVal) : null;
        }

        public <E extends Enum> E parseEnumValue(JsonPath pathToChangeType, Class<E> type, E defaultValue) {
            E value;
            String valueString = this.parseString(pathToChangeType);
            if (valueString == null) {
                value = defaultValue;
            } else {
                try {
                    value = Enum.valueOf(type, valueString);
                }
                catch (IllegalArgumentException e) {
                    log.debug(String.format("Unrecognised %s \"%s\" returned from Bitbucket Server %s, defaulting to %s.", type.getSimpleName(), valueString, this.stashLink.getName(), defaultValue));
                    value = defaultValue;
                }
            }
            return value;
        }

        public JsonWrapper getChildAtNode(JsonPath path) {
            return new JsonWrapper(this.parseValue(path), this.stashLink);
        }
    }
}

