/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.stash;

import com.atlassian.jirafisheyeplugin.stash.Author;
import com.atlassian.jirafisheyeplugin.stash.Change;
import com.atlassian.jirafisheyeplugin.stash.Page;
import com.atlassian.jirafisheyeplugin.stash.StashRepository;
import java.util.Date;

public class Commit {
    private static final int MAX_COMMIT_MESSAGE_LENGTH = 500;
    private static final int MAX_COMMIT_MESSAGE_NEW_LINES = 8;
    private static final String ELLIPSIS = "...";
    private final String displayHash;
    private final Author author;
    private final String absoluteUrl;
    private boolean merge;
    private final String message;
    private final Date date;
    private final StashRepository repository;
    private final Page<Change> changes;

    public Commit(String displayHash, Author author, String absoluteUrl, String message, boolean merge, Page<Change> changes, Date date, StashRepository stashRepository) {
        this.displayHash = displayHash;
        this.author = author;
        this.absoluteUrl = absoluteUrl;
        this.merge = merge;
        this.message = Commit.trimCommitMessage(message);
        this.changes = changes;
        this.date = date;
        this.repository = stashRepository;
    }

    static String trimCommitMessage(String message) {
        int originalLength = (message = message.trim()).length();
        message = originalLength > 500 ? message.substring(0, 500) : message;
        int newLines = 0;
        int i = 0;
        while (i > -1) {
            if (newLines++ >= 8) {
                message = message.substring(0, i);
                break;
            }
            i = message.indexOf(10, i + 1);
        }
        if (message.length() < originalLength) {
            message = message.trim();
            message = message + ELLIPSIS;
        }
        return message;
    }

    public Author getAuthor() {
        return this.author;
    }

    public String getDisplayHash() {
        return this.displayHash;
    }

    public String getAbsoluteUrl() {
        return this.absoluteUrl;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public Date getDate() {
        return this.date;
    }

    public Page<Change> getChanges() {
        return this.changes;
    }

    public StashRepository getRepository() {
        return this.repository;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Commit commit = (Commit)o;
        return !(this.absoluteUrl != null ? !this.absoluteUrl.equals(commit.absoluteUrl) : commit.absoluteUrl != null);
    }

    public int hashCode() {
        return this.absoluteUrl != null ? this.absoluteUrl.hashCode() : 0;
    }
}

