/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.rest.response;

import com.atlassian.jirafisheyeplugin.domain.fisheye.RevisionStats;
import com.atlassian.jirafisheyeplugin.rest.response.AbstractResponseParser;
import com.atlassian.jirafisheyeplugin.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

public class RevisionStatsParser
extends AbstractResponseParser<RevisionStats> {
    public static final RevisionStatsParser PARSER = new RevisionStatsParser();

    @Override
    public List<RevisionStats> parse(FishEyeDocumentHolder docHolder) throws IOException {
        Document doc = docHolder.getDoc();
        ArrayList<RevisionStats> stats = new ArrayList<RevisionStats>();
        List rows = doc.selectNodes("/response/row");
        for (Node row : rows) {
            Date date;
            String csid = row.valueOf("csid");
            int linesAdded = Integer.parseInt(row.valueOf("linesAdded"));
            int linesRemoved = Integer.parseInt(row.valueOf("linesRemoved"));
            try {
                date = FishEyeUtil.fromISO8601(row.valueOf("date"));
            }
            catch (ParseException e) {
                throw new IOException("Failed to retrieve revision stat date for changeset '" + csid + "'", e);
            }
            stats.add(new RevisionStats(csid, date, linesAdded, linesRemoved));
        }
        return stats;
    }
}

