/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.rest.response;

import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.rest.response.AbstractResponseParser;
import com.atlassian.jirafisheyeplugin.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

public class RevisionParser
extends AbstractResponseParser<Revision> {
    FishEyeRepository repository;
    private int maxRevisions;

    public RevisionParser(FishEyeRepository repository) {
        this.repository = repository;
        this.maxRevisions = Integer.MAX_VALUE;
    }

    @Override
    public List<Revision> parse(FishEyeDocumentHolder docHolder) throws IOException {
        Document doc = docHolder.getDoc();
        ArrayList<Revision> revisions = new ArrayList<Revision>();
        if (doc != null) {
            List rows = doc.selectNodes("/response/row");
            int revCount = 0;
            Iterator rowIt = rows.iterator();
            while (rowIt.hasNext() && revCount++ < this.maxRevisions) {
                Date date;
                Node row = (Node)rowIt.next();
                String author = row.valueOf("author");
                String rev = row.valueOf("revision");
                String csid = row.valueOf("csid");
                String path = row.valueOf("path");
                String comment = row.valueOf("comment");
                if (comment != null) {
                    comment = comment.trim();
                }
                int totalLines = Integer.parseInt(row.valueOf("totalLines"));
                int linesAdded = Integer.parseInt(row.valueOf("linesAdded"));
                int linesRemoved = Integer.parseInt(row.valueOf("linesRemoved"));
                String state = this.bool(row.valueOf("isMoved")) ? "moved" : (this.bool(row.valueOf("isCopied")) ? "copied" : (this.bool(row.valueOf("isDeleted")) ? "removed" : (this.bool(row.valueOf("isAdded")) ? "added" : "changed")));
                try {
                    date = FishEyeUtil.fromISO8601(row.valueOf("date"));
                }
                catch (ParseException e) {
                    throw new IOException("Failed to parse date for '" + this.repository.getName() + ":" + csid + ":" + path + "': " + e, e);
                }
                Revision revision = new Revision(path, rev, author, date, state, totalLines, linesAdded, linesRemoved, csid, comment, null, this.repository, docHolder.getBaseUrl(), docHolder.isCru());
                ArrayList<Review> reviews = new ArrayList<Review>();
                List reviewNodes = row.selectNodes("reviews/review");
                for (Node r : reviewNodes) {
                    reviews.add(this.extractReviewFromNode(r, docHolder.getBaseUrl()));
                }
                revision.setReviews(reviews);
                revisions.add(revision);
            }
        }
        return revisions;
    }

    private boolean bool(String s) {
        return Boolean.valueOf(s);
    }
}

