/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.rest.response;

import com.atlassian.jirafisheyeplugin.domain.crucible.MetaStateResolver;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.crucible.ReviewImpl;
import com.atlassian.jirafisheyeplugin.rest.response.AbstractResponseParser;
import com.atlassian.jirafisheyeplugin.rest.response.FishEyeDocumentHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Node;

public class CruRestServiceReviewParser
extends AbstractResponseParser<Review> {
    public static final CruRestServiceReviewParser PARSER = new CruRestServiceReviewParser();

    @Override
    public List<Review> parse(FishEyeDocumentHolder docHolder) throws IOException {
        Document doc = docHolder.getDoc();
        ArrayList<Review> reviews = new ArrayList<Review>();
        if (doc != null) {
            List reviewNodes = doc.selectNodes("/reviews/reviewData");
            reviews.addAll(this.parse(reviewNodes, docHolder.getBaseUrl(), null));
        }
        return reviews;
    }

    public List<Review> parse(List<Node> reviewNodes, String baseUrl, List<String> p4JobIds) {
        ArrayList<Review> reviews = new ArrayList<Review>();
        for (Node n : reviewNodes) {
            String id = n.valueOf("permaId/id");
            String title = n.valueOf("name");
            String description = n.valueOf("description");
            String state = n.valueOf("state");
            String linkedIssue = n.valueOf("jiraIssueKey");
            int metaState = MetaStateResolver.resolve(state);
            ReviewImpl review = new ReviewImpl(id, title, description, state, metaState, baseUrl, p4JobIds, linkedIssue);
            if (!this.passesFilter(review)) continue;
            reviews.add(review);
        }
        return reviews;
    }

    protected boolean passesFilter(Review review) {
        return true;
    }
}

