/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.rest.response;

import com.atlassian.core.util.collection.EasyList;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.rest.response.AbstractResponseParser;
import com.atlassian.jirafisheyeplugin.rest.response.CruRestServiceReviewParser;
import com.atlassian.jirafisheyeplugin.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.util.FishEyeUtil;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangesetParser
extends AbstractResponseParser<ChangesetHolder> {
    private static Logger log = LoggerFactory.getLogger(ChangesetParser.class);
    String csid;
    String repName;

    public ChangesetParser(String csid, String repName) {
        this.csid = csid;
        this.repName = repName;
    }

    @Override
    public List<ChangesetHolder> parse(FishEyeDocumentHolder docHolder) throws IOException {
        Date date;
        Document doc = docHolder.getDoc();
        Node csNode = doc.selectSingleNode("/response/changeset");
        try {
            date = FishEyeUtil.fromISO8601(csNode.valueOf("@date"));
        }
        catch (ParseException e) {
            date = null;
        }
        String author = csNode.valueOf("@author");
        String msg = csNode.valueOf("log");
        String branch = StringUtils.stripToNull(csNode.valueOf("@branch"));
        List revisionNodes = doc.selectNodes("/response/changeset/revisions/revisionkey");
        ArrayList<String> p4JobIds = new ArrayList<String>();
        for (Node node : csNode.selectNodes("p4JobIds")) {
            p4JobIds.add(node.getStringValue());
        }
        List<Review> reviews = CruRestServiceReviewParser.PARSER.parse(csNode.selectNodes("reviews/review"), docHolder.getBaseUrl(), p4JobIds);
        Changeset cs = new Changeset(this.repName, this.csid, author, date, msg, new ArrayList<Revision>(), docHolder.getBaseUrl(), docHolder.isCru(), branch, reviews);
        ArrayList<RevisionKey> keys = new ArrayList<RevisionKey>();
        for (Node revisionNode : revisionNodes) {
            log.debug("path: " + revisionNode.valueOf("@path") + " rev: " + revisionNode.valueOf("@rev"));
            keys.add(new RevisionKey(revisionNode.valueOf("@path"), revisionNode.valueOf("@rev")));
        }
        return EasyList.build((Object)new ChangesetHolder(cs, keys));
    }

    public static class ChangesetHolder {
        Changeset changeset;
        List<RevisionKey> revisionKeys;

        public ChangesetHolder(Changeset changeset, List<RevisionKey> revisionKeys) {
            this.changeset = changeset;
            this.revisionKeys = revisionKeys;
        }

        public Changeset getChangeset() {
            return this.changeset;
        }

        public List<RevisionKey> getRevisionKeys() {
            return this.revisionKeys;
        }
    }

    public static class RevisionKey {
        String path;
        String rev;

        public RevisionKey(String path, String rev) {
            this.path = path;
            this.rev = rev;
        }

        public String getPath() {
            return this.path;
        }

        public String getRev() {
            return this.rev;
        }
    }
}

