/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.rest.response;

import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.rest.response.CruRestServiceReviewParser;
import com.atlassian.jirafisheyeplugin.rest.response.FishEyeDocumentHolder;
import com.atlassian.jirafisheyeplugin.rest.response.ResponseParser;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.xml.bind.DatatypeConverter;
import org.dom4j.Document;
import org.dom4j.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChangesetDataFeResponseParser
implements ResponseParser<Changeset> {
    private static final Logger log = LoggerFactory.getLogger(ChangesetDataFeResponseParser.class);
    private final FishEyeRepository rep;
    private final Map<String, FishEyeRepository> reps;

    private ChangesetDataFeResponseParser(FishEyeRepository rep, Map<String, FishEyeRepository> reps) {
        this.rep = rep;
        this.reps = reps;
    }

    public ChangesetDataFeResponseParser(FishEyeRepository rep) {
        this(rep, null);
    }

    public ChangesetDataFeResponseParser(Map<String, FishEyeRepository> reps) {
        this(null, reps);
    }

    @Override
    public List<Changeset> parse(final FishEyeDocumentHolder docHolder) throws IOException {
        final Document document = docHolder.getDoc();
        List changesetNodes = document.selectNodes("/results/changesets/changeset");
        Collections.reverse(changesetNodes);
        return Lists.transform((List)changesetNodes, (Function)new Function<Node, Changeset>(){

            public Changeset apply(Node changesetNode) {
                final String repositoryName = ChangesetDataFeResponseParser.this.rep != null ? ChangesetDataFeResponseParser.this.rep.getName() : changesetNode.valueOf("repositoryName");
                final String csid = changesetNode.valueOf("csid");
                final Date date = this.parseDate(changesetNode.valueOf("date"));
                final String author = changesetNode.valueOf("author");
                final String msg = changesetNode.valueOf("comment").trim();
                String branch = changesetNode.valueOf("branch");
                int revisionSize = Integer.valueOf(changesetNode.selectSingleNode("revisions").valueOf("@size"), 10);
                List revisionNodes = changesetNode.selectNodes("revisions/revision");
                List revisions = Lists.transform((List)revisionNodes, (Function)new Function<Node, Revision>(){

                    public Revision apply(Node revisionNode) {
                        String path = revisionNode.valueOf("@path");
                        String rev = revisionNode.valueOf("@rev");
                        String ancestor = revisionNode.valueOf("@ancestor");
                        String state = revisionNode.valueOf("@fileRevisionState").toLowerCase(Locale.US);
                        int totalLines = Integer.parseInt(revisionNode.valueOf("@totalLines"), 10);
                        int linesAdded = Integer.parseInt(revisionNode.valueOf("@linesAdded"), 10);
                        int linesRemoved = Integer.parseInt(revisionNode.valueOf("@linesRemoved"), 10);
                        return new Revision(path, rev, author, date, state, totalLines, linesAdded, linesRemoved, csid, msg, ancestor, ChangesetDataFeResponseParser.this.rep != null ? ChangesetDataFeResponseParser.this.rep : (FishEyeRepository)ChangesetDataFeResponseParser.this.reps.get(repositoryName), docHolder.getBaseUrl(), docHolder.isCru());
                    }
                });
                List<Review> reviews = null;
                if (changesetNode.selectSingleNode("reviews") != null) {
                    ArrayList<String> p4JobIds = new ArrayList<String>();
                    for (Node node : changesetNode.selectNodes("p4JobIds")) {
                        p4JobIds.add(node.getStringValue());
                    }
                    reviews = CruRestServiceReviewParser.PARSER.parse(changesetNode.selectNodes("reviews/review"), docHolder.getBaseUrl(), p4JobIds);
                }
                Changeset changeset = new Changeset(repositoryName, csid, author, date, msg, revisions, docHolder.getBaseUrl(), docHolder.isCru(), branch, reviews);
                if (revisionSize > revisionNodes.size()) {
                    changeset.setIncomplete(revisionSize - revisionNodes.size());
                }
                return changeset;
            }

            private Date parseDate(String dateString) {
                Date date;
                try {
                    date = DatatypeConverter.parseDateTime((String)dateString).getTime();
                }
                catch (IllegalArgumentException e) {
                    log.error("unable to parse date : [" + dateString + "]. See debug log for details", (Throwable)e);
                    if (log.isDebugEnabled()) {
                        log.debug("unable to parse date : [" + dateString + "], DatatypeConverter.parseDateTime() threw IllegalArgumentException: [" + document.asXML() + "]", (Throwable)e);
                    }
                    date = new Date(0L);
                }
                return date;
            }
        });
    }
}

