/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.rest.command;

import com.atlassian.jirafisheyeplugin.rest.command.RestCommand;
import com.atlassian.sal.api.net.Request;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.core.UriBuilder;

public class RestCommandImpl<T>
implements RestCommand<T> {
    private final String path;
    private final Map<String, String> params;
    private final Map<String, Set<String>> listParams;
    private final Request.MethodType methodType;

    public RestCommandImpl(String path, Map<String, String> params, Request.MethodType methodType) {
        this(path, params, Collections.emptyMap(), methodType);
    }

    protected RestCommandImpl(String path, Map<String, String> params, Map<String, Set<String>> listParams, Request.MethodType methodType) {
        this.path = path;
        this.listParams = listParams;
        this.params = new HashMap<String, String>(params);
        this.methodType = methodType;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Map<String, String> getParameters() {
        return this.params;
    }

    @Override
    public Map<String, Set<String>> getListParameters() {
        return this.listParams;
    }

    @Override
    public Request.MethodType getMethodType() {
        return this.methodType;
    }

    @Override
    public URI makeAbsoluteURL(String baseUrl) {
        return UriBuilder.fromUri((String)(baseUrl.endsWith("/") ? baseUrl : baseUrl + "/")).path(this.getPath()).build(new Object[0]);
    }

    @Override
    public URI makeAbsoluteURL(URI baseUrl) {
        return this.makeAbsoluteURL(baseUrl.toString());
    }

    public String toString() {
        return "AbstractRestCommand{path='" + this.path + '\'' + ", params=" + this.params + ", methodType=" + this.methodType + '}';
    }
}

