/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jirafisheyeplugin.rest.command;

import com.atlassian.jirafisheyeplugin.config.SearchConfig;
import com.atlassian.jirafisheyeplugin.domain.crucible.CrucibleProject;
import com.atlassian.jirafisheyeplugin.domain.crucible.Review;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Changeset;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeInstance;
import com.atlassian.jirafisheyeplugin.domain.fisheye.FishEyeRepository;
import com.atlassian.jirafisheyeplugin.domain.fisheye.Revision;
import com.atlassian.jirafisheyeplugin.domain.fisheye.ServerInfo;
import com.atlassian.jirafisheyeplugin.rest.command.CrucibleRestCommand;
import com.atlassian.jirafisheyeplugin.rest.command.FishEyeRestCommand;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommand;
import com.atlassian.jirafisheyeplugin.rest.command.RestCommandImpl;
import com.atlassian.jirafisheyeplugin.rest.eyeql.EyeQLQuery;
import com.atlassian.jirafisheyeplugin.rest.response.ChangesetParser;
import com.atlassian.sal.api.net.Request;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RestCommandFactory {
    private static final int MAX_CHANGESETS_HARD_LIMIT = 100;

    public static <T> RestCommand<T> query(String eyeQL) {
        return new FishEyeRestCommand("query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)eyeQL));
    }

    public static <T> RestCommand<T> query(EyeQLQuery query) {
        return RestCommandFactory.query(query.toString());
    }

    public static RestCommand<String> repositories() {
        return new FishEyeRestCommand<String>("repositories", Collections.emptyMap());
    }

    public static RestCommand<ChangesetParser.ChangesetHolder> changeset(String csid) {
        return new FishEyeRestCommand<ChangesetParser.ChangesetHolder>("changeset", (Map<String, String>)ImmutableMap.of((Object)"csid", (Object)csid));
    }

    public static RestCommand<String> changesets(String path, int maxReturn) {
        return new FishEyeRestCommand<String>("changesets", (Map<String, String>)ImmutableMap.of((Object)"path", (Object)path, (Object)"maxReturn", (Object)String.valueOf(maxReturn)));
    }

    public static RestCommand<Revision> revision(String path, String revision) {
        return new FishEyeRestCommand<Revision>("revision", (Map<String, String>)ImmutableMap.of((Object)"path", (Object)path, (Object)"rev", (Object)revision));
    }

    public static RestCommand testAccess() {
        return new FishEyeRestCommand("query", (Map<String, String>)ImmutableMap.of((Object)"query", (Object)"select revisions where date == now"));
    }

    public static RestCommand<CrucibleProject> projects() {
        return new CrucibleRestCommand<CrucibleProject>("projects-v1", Collections.singletonMap("excludeAllowedReviewers", "true"));
    }

    public static RestCommand<Review> reviewSearch(String term) {
        return new CrucibleRestCommand<Review>("search-v1/reviews", (Map<String, String>)ImmutableMap.of((Object)"term", (Object)term, (Object)"maxReturn", (Object)String.valueOf(50)));
    }

    public static RestCommand<ServerInfo> serverInfo() {
        return new RestCommandImpl<ServerInfo>("/rest-service-fe/server-v1", Collections.emptyMap(), Request.MethodType.GET);
    }

    public static RestCommand<Changeset> listChangesets(FishEyeInstance instance, String comment, Set<FishEyeRepository> repositories, SearchConfig searchConfig) {
        String expand = searchConfig.getMaxRevisions() > 0 ? RestCommandFactory.computeExpandParameter(searchConfig) : String.format("changesets[-%d:-%d]", 100, 1);
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"expand", (Object)expand).put((Object)"query", (Object)comment);
        ImmutableMap queryParams = builder.build();
        HashSet<String> repNames = new HashSet<String>();
        for (FishEyeRepository rep : repositories) {
            repNames.add(rep.getName());
        }
        return new RestCommandImpl<Changeset>("/rest-service-fe/search-v1/crossRepositoryQuery", (Map<String, String>)queryParams, Collections.singletonMap("repository", repNames), Request.MethodType.GET);
    }

    public static RestCommand<Changeset> listChangesets(FishEyeRepository rep, String comment, SearchConfig searchConfig) {
        ImmutableMap.Builder builder = ImmutableMap.builder().put((Object)"rep", (Object)rep.getName()).put((Object)"expand", (Object)RestCommandFactory.computeExpandParameter(searchConfig));
        if (searchConfig.getRepositoryPath() != null) {
            if (!rep.getName().equals(searchConfig.getRepositoryPath().getRep().getName())) {
                throw new IllegalStateException("The passed in 'rep' is not the same repository as the one specified in the RepositoryPath object in searchConfig : rep=" + rep + " searchConfig=" + searchConfig);
            }
            builder.put((Object)"path", (Object)searchConfig.getRepositoryPath().getPath());
        } else {
            builder.put((Object)"comment", (Object)comment).put((Object)"p4JobFixed", (Object)comment);
        }
        ImmutableMap queryParams = builder.build();
        return new RestCommandImpl<Changeset>("/rest-service-fe/changeset-v1/listChangesets/", (Map<String, String>)queryParams, Request.MethodType.GET);
    }

    private static String computeExpandParameter(SearchConfig searchConfig) {
        if (searchConfig.isChronological()) {
            return String.format("changesets[-%d:-1].revisions[0:%d],reviews", RestCommandFactory.add(searchConfig.getMaxChangesets(), 1), searchConfig.getMaxRevisions() - 1);
        }
        return String.format("changesets[0:%d].revisions[0:%d],reviews", searchConfig.getMaxChangesets(), searchConfig.getMaxRevisions() - 1);
    }

    public static RestCommand<Changeset> listMoreChangesets(FishEyeRepository rep, String issueKey, SearchConfig searchConfig, Map<FishEyeRepository, Integer> searchIndex) {
        return new RestCommandImpl<Changeset>("/rest-service-fe/changeset-v1/listChangesets/", (Map<String, String>)ImmutableMap.of((Object)"rep", (Object)rep.getName(), (Object)"comment", (Object)issueKey, (Object)"p4JobFixed", (Object)issueKey, (Object)"expand", (Object)String.format("changesets[-%d:-%d]", 100, 1)), Request.MethodType.GET);
    }

    private static int add(int number, int toAdd) {
        int r = number + toAdd;
        return r < 0 ? Integer.MAX_VALUE : r;
    }
}

